#ifndef Locate_H
#define Locate_H

#define OUTERRING_D     140             //外輪間距離(mm)
#define INNERRING_D     136             //内輪間距離(mm)
#define PI              3.14159         //π
#define RESOLUSION      200             //P/R(分解能)
#define DIAMETER        31.8            //タイヤの直径(mm)
#define LOCATE_STEP     (DIAMETER*PI / RESOLUSION)                  // エンコーダの１ステップあたりの距離(mm)
#define TIRE_DISTANCE   ((OUTERRING_D + INNERRING_D) / 2)           //タイヤ間距離(mm)
#define ROUND           (PI * DIAMETER / (RESOLUSION * TIRE_DISTANCE))   //機体が１回転するために必要なステップ数の”逆数”

/*
エンコーダから、現在のステップ数（＝タイヤがどれだけ回ったか）を得られる
今回は分解能が200だから、(タイヤ1回転) = (200ステップ)
*/



class Locate
{
//引数のr,lはエンコーダから受け取るステップ数で、rは右車輪、lは左車輪

private:
    int pr, pl;     //前回のステップ数
    char dl, dr;    //エンコーダの初期ズレ
    short v;        //ステップ速度
    float x, y;     //xy方向に進んだ距離(m換算なし)
    float theta;    //機体角度、x軸正の向きを0とする
public:    
    Locate (int fx, int fy);        //fx,fyは初期位置
    void  setup(int r, int l);      //エンコーダの初期のズレ(dr,dl)を出す、最初に一回だけ行う
    void  update (int r, int l);    //位置情報を更新する。r,lはエンコーダから
    short getX();                   //xをmm換算して整数値として返す
    short getX(int r, int l);       //上のupdate()も一緒にやってくれる版
    short getY();                   //yをmm換算して整数値として返す
    short getY(int r, int l);       //上のupdate()も一緒にやってくれる版
    float getTheta();               //thetaを返す
};

#endif