#include <math.h>
#include "Locate.h"


Locate::Locate (int fx, int fy) 
{
    x = fx;
    y = fy;
    dr = 0; dl = 0;
    pr = 0; pl = 0;
}

void Locate::setup(int r, int l)
{
    pr = dr = r;    //(今(最初)のステップ数) = (初期ズレ) = (エンコーダから受け取るステップ数)
    pl = dl = l;    //上の説明は意味不明なので無視してください
}


void Locate::update (int r, int l) 
{
    r -= dr; l -= dl;   //ズレを修正
    
    theta = (r - l) * ROUND;   
    v = (r-pr + l-pl);     //r-pr = 前回から右車輪が進んだステップ数
    
    x += v * (cos(theta))   ;
    y += v * (sin(theta));
    
    pr = r;                 //今回のステップ数を保存
    pl = l;
}


short Locate::getX()
{
    return x * LOCATE_STEP / 2;   
}

short Locate::getX(int r, int l)
{
    update(r, l);
    return x * LOCATE_STEP / 2;   
}

short Locate::getY()
{
    return y * LOCATE_STEP / 2;   
}

short Locate::getY(int r, int l)
{
    update(r, l);
    return y * LOCATE_STEP / 2;   
}

float Locate::getTheta()
{
    return theta;
}