#pragma once
#include "mbed.h"

#include <string>
#include <cctype>
#include <algorithm>

#include "Clock.h"
#include "Reader.h"

class Command
{
private:
    string error;

protected:
    const string *argv;
    const uint8_t argc;

    Reader *reader;

    bool isHelp() const;
    void setError(const string &error);

public:
    Command(const string *argv, uint8_t argc);
    virtual ~Command();

    const string getError() const;
    const string getFirstParameter() const;

    virtual bool execute();
    virtual void printHelp() const;
};

class ValidCommand : public Command
{
public:
    ValidCommand(const string *argv, uint8_t argc);
};

class InvalidCommand : public Command
{
public:
    InvalidCommand(const string *argv, uint8_t argc);
    bool execute();
};

class PruebaCommand : public ValidCommand
{
private:

public:
    PruebaCommand(const string *argv, uint8_t argc);
    
    bool execute();
    void printHelp() const;   
};