#include "Reader.h"
#include "Pinout.h"
#include "Log.h"


extern Log _;

Reader::Reader()
{
    this->clock = Clock::getInstance();
}

Reader* Reader::getInstance()
{
    static Reader* instance = new Reader();
    return instance;
}

const string Reader::readLine(uint32_t timeout, bool showPrompt)
{
    if (showPrompt) {
        _.ln().print("Prueba Hsens $ ");
    }
    _.flush();

    string line = "";
    time_t currentTime = this->clock->getUnixTime();
    bool completedLine = false;

    Serial* console = _.getSerial();
    while ((uint32_t)(this->clock->getUnixTime() - currentTime) <= timeout && !completedLine) {
        if (console->readable()) {
            char ch = console->getc();
        _.print(ch);
            switch (ch) {
                case '\r':
                case '\n':
                    completedLine = true;
                    break;
                default:
                    line += ch;
            }
        }
    }
    if (completedLine) {
        _.ln();
        return line;
    } else {
        return "";
    }
}