#pragma once

#include "mbed.h"
#include <string>

class Log
{
private:
    Serial* serial;
    bool wasLineBreak;

    void printInfo();

public:
    explicit Log(Serial* serial = NULL);
    ~Log();

    Serial* getSerial() const;
    void setSerial(Serial* serial);

    Log& print(const char*);
    Log& print(const string&);
    Log& print(bool value);
    Log& print(unsigned char num, uint8_t base = 10);
    Log& print(unsigned int num, uint8_t base = 10);
    Log& print(unsigned long num, uint8_t base = 10);
    Log& print(unsigned long long num, uint8_t base = 10);
    Log& print(char c);
    Log& print(int num);
    Log& print(long num);
    Log& print(long long num);
    Log& print(double num, uint8_t decimals = 2);
    Log& printf(const char* fmt, ...);
    Log& ln(uint8_t quantity = 1);

    Log& flush();
};
