#include "Log.h"
#include "Clock.h"

Log::Log(Serial* serial)
    : serial(serial)
{
    this->wasLineBreak = true;
}

Log::~Log()
{
    delete this->serial;
}

Serial* Log::getSerial() const
{
    return this->serial;
}

void Log::setSerial(Serial* serial)
{
    if (this->serial != NULL) {
        delete this->serial;
    }
    this->serial = serial;
}

Log& Log::print(const char* str)
{
    this->printInfo();
    this->serial->puts(str);
    return *this;
}

Log& Log::print(const string& str)
{
    return this->print(str.c_str());
}

Log& Log::print(bool value)
{
    if (value) {
        return this->print("true");
    } else {
        return this->print("false");
    }
}

Log& Log::print(unsigned char num, uint8_t base)
{
    return this->print((unsigned int)num, base);
}

Log& Log::print(unsigned int num, uint8_t base)
{
    if (base == 10) {
        if (this->serial != NULL) {
            this->printInfo();
            this->serial->printf("%u", num);
        }
    } else if (base == 16) {
        if (this->serial != NULL) {
            this->printInfo();
            this->serial->printf("%X", num);
        }
    } else {
        return this->print(num);
    }
    return *this;
}

Log& Log::print(unsigned long num, uint8_t base)
{
    if (base == 10) {
        if (this->serial != NULL) {
            this->printInfo();
            this->serial->printf("%lu", num);
        }
    } else if (base == 16) {
        if (this->serial != NULL) {
            this->printInfo();
            this->serial->printf("%lX", num);
        }
    } else {
        return this->print(num);
    }
    return *this;
}

Log& Log::print(unsigned long long num, uint8_t base)
{
    if (base == 10) {
        if (this->serial != NULL) {
            this->printInfo();
            this->serial->printf("%lu", num);
        }
    } else if (base == 16) {
        if (this->serial != NULL) {
            this->printInfo();
            this->serial->printf("%lX", num);
        }
    } else {
        return this->print(num);
    }
    return *this;
}

Log& Log::print(char c)
{
    if (this->serial != NULL) {
        this->serial->putc(c);
    }
    return *this;
}

Log& Log::print(int num)
{
    if (this->serial != NULL) {
        this->printInfo();
        this->serial->printf("%d", num);
    }
    return *this;
}

Log& Log::print(long num)
{
    if (this->serial != NULL) {
        this->printInfo();
        this->serial->printf("%ld", num);
    }
    return *this;
}

Log& Log::print(double num, uint8_t decimals)
{
    if (this->serial != NULL) {
        this->printInfo();

        char format[10];
        snprintf(format, sizeof format, "%%.%df", decimals);
        this->serial->printf(format, num);
    }
    return *this;
}

Log& Log::printf(const char* fmt, ...)
{
    if (this->serial != NULL) {
        this->printInfo();

        va_list args;
        va_start(args, fmt);
        this->serial->vprintf(fmt, args);
        va_end(args);
    }
    return *this;
}

Log& Log::ln(uint8_t quantity)
{
    if (this->serial != NULL) {
        for (uint8_t i = 0; i < quantity; i++) {
            this->serial->puts("\r\n");
        }
    }
    this->wasLineBreak = true;
    return *this;
}

Log& Log::flush()
{
    fflush(stdout);
    return *this;
}

void Log::printInfo()
{
    if (this->wasLineBreak) {
        this->wasLineBreak = false;
        this->print(Clock::getInstance()->getTimeAsAString())
                .print("; ram: ").print("   ");
    }
}
