#pragma once

#include "mbed.h"

#include "Command.h"
#include "Reader.h"

class Console
{
private:
    Console(Console const&);
    void operator=(Console const&);

    uint32_t timeout;
    Reader *reader;

    Command* parse(string command) const;

public:
    explicit Console(uint32_t timeout = 120);

    void start();
    bool execute(Command* command);
    bool isFinishCommand(const string &command) const;
};
