#include "Console.h"
#include "Log.h"

extern Log _;

Console::Console(uint32_t timeout)
    : timeout(timeout)
{
    this->reader = Reader::getInstance();
}

Command* Console::parse(string command) const
{
    // trim
    {
        size_t first = command.find_first_not_of(' ');
        size_t last = command.find_last_not_of(' ');
        if (first != string::npos && last != string::npos) {
            command = command.substr(first, last - first + 1);
        }
    }

    // remove backspaces
    {
        const char backspaces[] = {0x8, 0x7F};
        for (uint8_t i = 0; i < sizeof(backspaces) / sizeof(backspaces[0]); i++) {
            size_t index = command.find_first_of(backspaces[i]);
            while (index != string::npos) {
                command.erase(index, 1);
                if (index != 0) {
                    command.erase(index - 1, 1);
                }
                index = command.find_first_of(backspaces[i]);
            }
        }
    }

    // remove control characters
    {
        size_t i = command.length();
        if (i != 0) {
            do {
                i--;
                if (iscntrl(command[i])) {
                    command.erase(i, 1);
                }
            } while (i != 0);
        }
    }

    // remove extra whitespaces
    {
        size_t length, newLength = command.length();
        do {
            length = newLength;
            size_t found = command.find("  ");
            if (found != string::npos) {
                command.replace(found, 2, " ");
            }
            newLength = command.length();
        } while (length != newLength);
    }

    // count whitespaces
    size_t length = command.length();
    uint8_t spacesNum = 0;
    for (uint16_t i = 0; i < length; i++) {
        if (command[i] == ' ') {
            spacesNum++;
        }
    }

    // break into pieces
    uint8_t argc = spacesNum + 1;
    string *argv = new string[argc];
    size_t pos = 0;
    for (uint8_t i = 0; i < spacesNum; i++) {
        size_t len = command.find_first_of(' ', pos) - pos;
        argv[i] = command.substr(pos, len);
        pos += len + 1;
    }
    argv[spacesNum] = command.substr(pos);

    // to lower case
    transform(argv[0].begin(), argv[0].end(), argv[0].begin(), ::tolower);

    // make command
    if (argv[0].empty()) {
        delete[] argv;
        return NULL;
    } else if (argv[0] == "prueba") {
        return new PruebaCommand(argv, argc);
    } else {
        return new InvalidCommand(argv, argc);
    }
}

void Console::start()
{
    bool end = false;
    uint8_t intentos = 0;
    while (!end) {
        const string cmd = this->reader->readLine(this->timeout);
        if (cmd.length() != 0) {
            if (this->isFinishCommand(cmd)) {
                end = true;
            } else {
                Command* command = this->parse(cmd);
                if (command != NULL) {
                    if (!this->execute(command)) {
                        _.print("Error: ").print(command->getError()).ln();
                    }
                    delete command;
                }
            }
        } else {
            if(intentos > 5) {
                end = true;
            } else {
                intentos++;
            }
        }
    }
}

bool Console::execute(Command* command)
{
    return command->execute();
}

bool Console::isFinishCommand(const string &command) const
{
    return command == "finish" || command == "end" || command == "exit";
}
