#pragma once

#include <string>
#include "WakeUp.h"

#define RCC_PLL_TIMEOUT_VALUE          ((uint32_t)2U)    /* 2 ms (minimum Tick + 1) */

class Clock{
    private:
        Clock();
        ~Clock();
        Clock(Clock const&);
        void operator=(Clock const&);
        uint32_t prediv_s;
        bool hibernate;
    public:
        static const uint32_t SECONDS_IN_A_DAY = 3600 * 24;

        static Clock* getInstance();

        time_t getUnixTime();
        uint32_t getMilliSeconds();
        const struct tm* getTmStruct();
        const string getTimeAsAString();

        void updateUnixTime(time_t unixTime);

        void programAlarm(uint32_t seconds);
        void goToSleep();
        uint8_t SetSysClock_PLL_HSE(uint8_t bypass);
        uint8_t SetSysClock_PLL_HSI();
        uint8_t SetSysClock_MSI();
        void resetClockRegisters();
        void initClock();
        void printClockInfo();

        void readRegisters();
        void printRegisters();

};
