#include "Command.h"
#include "Log.h"
#include "prueba_hsens.h"
#include "Pinout.h"
#include <stdio.h>                              //Para luego escribir printf, me compilaba también sin ponerlo

extern prueba_hsens * sensores;                 //Exporto el objeto
extern Log _;

Command::Command(const string* argv, uint8_t argc)
    : argv(argv), argc(argc)
{
    this->error = "";
    this->reader = Reader::getInstance();
}

Command::~Command()
{
    delete[] this->argv;
}

bool Command::isHelp() const
{
    int8_t index = -1;
    if (this->argc > 0) {
        index = 0;
        if (this->argc > 1) {
            index = 1;
        }
    }
    if (index != -1) {
        return this->argv[index] == "?" || this->argv[index] == "help";
    } else {
        return false;
    }
}

void Command::setError(const string &error)
{
    this->error = error;
}

const string Command::getError() const
{
    return this->error;
}

const string Command::getFirstParameter() const
{
    return this->argc > 0 ? this->argv[0] : "";
}

bool Command::execute()
{
    if (this->isHelp()) {
        this->printHelp();
        return true;
    } else {
        return false;
    }
}

void Command::printHelp() const
{
    _.print("Available commands:").ln();
    _.print("  prueba                - Para combrobar el funcionamiento del sensor").ln();
}

ValidCommand::ValidCommand(const string* argv, uint8_t argc)
    : Command(argv, argc)
{
}

InvalidCommand::InvalidCommand(const string* argv, uint8_t argc)
    : Command(argv, argc)
{
}

bool InvalidCommand::execute()
{
    if (this->isHelp()) {
        this->printHelp();
        return true;
    } else {
        _.print("Hexadecimal representation of command: ");
        for (uint8_t i = 0, n = this->argv[0].length(); i < n; i++) {
            _.print((uint8_t)this->argv[0][i], 16).print(' ');
        }
        _.ln();
        string error = "Invalid command: '" + this->argv[0] + "'";
        this->setError(error);
        return false;
    }
}

 PruebaCommand::PruebaCommand(const string *argv, uint8_t argc)
     : ValidCommand(argv, argc)
{
    //Crearia el objeto en el caso que no lo tendria hecho de forma global
    //Lo mejor hubiera sido crear un objeto aqui el cual lo obtendriamos de una de las partes del objeto global
}

bool PruebaCommand::execute()
{
    if(ValidCommand::execute()) {
        return true;
    }else if (this->argc > 1) {
        if (this->argv[1] == "tension") {
            sensores->medir_tension();
            return true;
        }else {
            return false;
        }
    }
    this->setError("Invalid command");
    return false;        
}

void PruebaCommand::printHelp() const
{
    _.print("Help for 'Prueba Hsens' command:").ln();
    _.print("tension          - Da la tensión que envía el sensor.").ln();

}
