#include "mbed.h"
#include "math.h"
#include "stdbool.h"
 
I2C i2c(I2C_SDA, I2C_SCL);
Serial pc(SERIAL_TX, SERIAL_RX);

int addr = 0x00;

union temp_union_t {                                //Variables union para poder enviar el float por el I2C
    float temp_float;
    uint8_t data_t[4];
}temp_union;

union hum_union_t{
    float hum_float;
    uint8_t data_h[4];
}hum_union;

 
int main() {
   
    char cmd[5];
     
    while (1) {
        for (int k=1;k<16;k++){
            
            addr = k<<1; 
            
            cmd[0] = 0x01;
            i2c.write(addr, cmd, 1);
            
            int fallo1 = i2c.read(addr, cmd, 4);
            temp_union.data_t[0] = cmd[0];
            temp_union.data_t[1] = cmd[1];
            temp_union.data_t[2] = cmd[2];
            temp_union.data_t[3] = cmd[3];
            
            int fallo2 = i2c.read(addr, cmd, 4);
            hum_union.data_h[0] = cmd[0];
            hum_union.data_h[1] = cmd[1];
            hum_union.data_h[2] = cmd[2];
            hum_union.data_h[3] = cmd[3];
            
            if (fallo1 ==0 and fallo2 == 0){
                printf ("Tramo numero: ");
                printf ("%i", k);
                printf (". Temperatura: ");
                printf("%f", temp_union.temp_float);
                printf (". Humedad: ");
                printf("%f", hum_union.hum_float);
                printf (".");
                printf ("\n");
            }else{
                printf ("Tramo numero: ");
                printf ("%i", k);
                printf (". Tramo de separacion.");
                printf ("\n"); 
            }
            
            wait(3);

        }
    }
}
 
