#ifndef IWCMD_H
#define IWCMD_H

/*
*  Iwatobiシリアル通信用コマンド一覧
*/

/** ControlModule Command **/
#define IWCMD_CM_SS1_PP 'q' // スラスターサーボ1を正位置
#define IWCMD_CM_SS1_SP 'a' // スラスターサーボ1を零位置
#define IWCMD_CM_SS1_NP 'z' // スラスターサーボ1を負位置
#define IWCMD_CM_SS2_PP 'w' // スラスターサーボ2を正位置
#define IWCMD_CM_SS2_SP 's' // スラスターサーボ2を零位置
#define IWCMD_CM_SS2_NP 'x' // スラスターサーボ2を負位置
#define IWCMD_CM_SS3_PP 'e' // スラスターサーボ3を正位置
#define IWCMD_CM_SS3_SP 'd' // スラスターサーボ3を零位置
#define IWCMD_CM_SS3_NP 'c' // スラスターサーボ3を負位置
#define IWCMD_CM_SS4_PP 'r' // スラスターサーボ4を正位置
#define IWCMD_CM_SS4_SP 'f' // スラスターサーボ4を零位置
#define IWCMD_CM_SS4_NP 'v' // スラスターサーボ4を負位置
#define IWCMD_CM_SS5_PP 't' // スラスターサーボ5を正位置
#define IWCMD_CM_SS5_SP 'g' // スラスターサーボ5を零位置
#define IWCMD_CM_SS5_NP 'b' // スラスターサーボ5を負位置
#define IWCMD_CM_SS6_PP 'y' // スラスターサーボ6を正位置
#define IWCMD_CM_SS6_SP 'h' // スラスターサーボ6を零位置
#define IWCMD_CM_SS6_NP 'n' // スラスターサーボ6を負位置
#define IWCMD_CM_PM1_FR 'u' // PM1を正転(IWCMD_PM1_SUU)
#define IWCMD_CM_PM1_ST 'j' // PM1を停止(IWCMD_PM1_SPS)
#define IWCMD_CM_PM2_FR 'i' // PM2を正転(IWCMD_PM2_SUU)
#define IWCMD_CM_PM2_ST 'k' // PM2を停止(IWCMD_PM2_SPS)


/** PowerModule Command **/
#define IWCMD_PM1_SUU 'a' // PM1スラスターのDuty比上昇率を正
#define IWCMD_PM1_SPU 'u' // PM1スラスターのDuty比を上昇
#define IWCMD_PM1_SPD 'd' // PM1スラスターのDuty比を減少
#define IWCMD_PM1_PPU ';' // PM1ポンプのDuty比を上昇
#define IWCMD_PM1_PPD '-' // PM1ポンプのDuty比を減少
#define IWCMD_PM1_SPS 's' // PM1のスラスターとポンプを停止
#define IWCMD_PM1_CCO 'c' // PM1の接続確認
#define IWCMD_PM2_SUU 'A' // PM2スラスターのDuty比上昇率を正
#define IWCMD_PM2_SPU 'U' // PM2スラスターのDuty比を上昇
#define IWCMD_PM2_SPD 'D' // PM2スラスターのDuty比を減少
#define IWCMD_PM2_PPU '+' // PM2ポンプのDuty比を上昇
#define IWCMD_PM2_PPD '=' // PM2ポンプのDuty比を減少
#define IWCMD_PM2_CCO 'C' // PM2の接続確認
#define IWCMD_PM2_SPS 'S' // PM2のスラスターとポンプを停止

#endif //IWCMD_H