#include "nRF24L01P.h"
#include "MMA8451Q.h"
#include "TSISensor.h" 
#define MMA8451_addr (0X1d<<1)

MMA8451Q acc(PTE25,PTE24,MMA8451_addr);
TSISensor tsi;
Serial pc(USBTX, USBRX);
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);   

int main()
{
    char count[4];
    float x,y,tsival;
    char TxDataCnt;
    char temp;
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2400);
    TxDataCnt = 4;
    my_nrf24l01p.setTransferSize(TxDataCnt);
    my_nrf24l01p.enable();
    while (1)
         {
           x=acc.getAccX();
           y=acc.getAccY();
           count[0]=(y+2.0f)*50.0f;
           count[1]=(x+2.0f)*50.0f;
           tsival=tsi.readPercentage();
           if(tsival!=0)
           {
           if(tsival>=0.6)
              {
        
               count[2]=1;
               count[3]=0;
               }
          else    if(tsival<=0.4&&tsival!=0.0)
              {
                count[3]=1;
                count[2]=0;
              }
            }
        else
            {
            count[3]=0;
            count[2]=0;
            }
        temp = my_nrf24l01p.write( NRF24L01P_PIPE_P0,count, TxDataCnt );
        pc.printf( "Sending %d - %d %d %d %d\r\n",temp,count[0],count[1],count[2],count[3]);
        wait(0.2);
    }
}
