#include "mbed.h"
#include "nRF24L01P.h"
#include "MMA8451Q.h"
#include "TSISensor.h"
#include "USBMouse.h"  
#define MMA8451_addr (0X1d<<1)
USBMouse mouse;
MMA8451Q acc(PTE25,PTE24,MMA8451_addr);
TSISensor tsi;
Serial pc(USBTX, USBRX); 
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4); 

int main() 
{
    char count[4];
    char RxDataCnt;
    float x,y;
    char temp;
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2400);
    
    RxDataCnt = 4;
    my_nrf24l01p.setTransferSize( RxDataCnt );
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1)
     {

        if ( my_nrf24l01p.readable() ) 
        {
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt );
            //  pc.printf( "Cnt %d = %d %d %d %d\r\n",temp,count[0],count[1],count[2],count[3]);
            y=count[0];
            x=count[1];
            y=(y/50.0f)-(float)2;
            x=(x/50.0f)-(float)2;
            mouse.move(-1.0f*y*20.0f,x*20.0f);
            if(count[2]==1)
                {
                mouse.press(MOUSE_LEFT);
                }
            else if(count[3]==1)
                {
                mouse.press(MOUSE_RIGHT);
                }
            else
                {
                 mouse.release(MOUSE_LEFT);
                 mouse.release(MOUSE_RIGHT);
                 }
                 
            wait_ms(50);
        }
    }
}
