#include "mbed.h"
#include <Pulse.h>
#include "DebouncedIn.h"
#define off 1
#define on 0

Serial pc(USBTX,USBRX); // Abre puerto serial
Serial GSM(PTE0,PTE1);

DigitalOut LedVerde(LED2,off);
DigitalOut LedRojo(LED1,off);
DigitalOut LedAzul(LED3,off);
//DigitalOut bomba(PTA17); // Pin para activar la bomba
PulseInOut pulseIn(PTD4); // Generamos los pulsos

//DebouncedIn levelBalde(PTC17); // Sensor de nivel del balde
//DebouncedIn levelTanque(PTC16); // Sensor de nivel en el tanque de almacenamiento
AnalogIn input(PTC2);

int cPulsos; // Cuenta los pulsos
int limBmax = 5; // Límite de agua máximo en el balde. 50 cm.
//int limBmin = 1; // Límite de agua mínimo en el balde. 10 cm
int i, j, k, m, num;
int bomba = 0; // Vamos a generar 3 ciclos de llenado del tanque. Al tercer ciclo, el balde quedará vacío y se deberá detectar de nuevo flujo.
bool control = true; // Para terminar el programa.

void pulsos() // Generación de pulsos
{
    pulseIn.write_us(0, 200000);  // 200 ms tiempo bajo
    cPulsos++; // Cuenta cuando hay un flanco de bajada
    pulseIn.write_us(1, 50000); // 50 ms  arriba
}

void sendData(float input)
{
    wait(1);
    num = input*1000;      //agrando el numero de cero a mil
    GSM.putc(num);
    pc.printf("Nivel del tanque: %f [m].\r\n", input);
    if(num < 256) {          //debo generar dos casos a APP inventor solo me recibe hex asi: 0xhhhh (4 cifras)
        GSM.putc(0);     //si el numero es hasta 255 se le ponen dos ceros adelante a la secuencia de bits
        GSM.putc(i);     //luego la cifra menos significativa
        //pc.printf("Cero: %d\r\n", 0);
        //pc.printf("m: %d\r\n", m);
    }
    if(num >255) {         //pero si es mayor a 255 las cifras deben ser convertidas a un hex de dos bytes de la siguiente forma
        j = num/256;       //calculo la cifra mas significativa
        k = num - j*256;     //calculo la cifra menos significativa
        GSM.putc(j);   //las envio a la usart para que se las ponga al modulo bluetooth y la lleve al android
        GSM.putc(k);   //mas significativa primero, menos despues si no no funciona!!! y con la orden PUTC solo asi le envia binarios
        //pc.printf("j: %d\r\n", j);
        //pc.printf("k: %d\r\n", k);
    }
}


int main()
{
    GSM.baud(9600);   // asigno baudios y configuro puerto serie de la usart
    GSM.format(8,Serial::None,1);
    wait(1);
    pc.printf("Ahorrador de agua\r\n");
    pc.printf("El programa se esta iniciando\r\n");
    wait(0.2);
    LedVerde = on;
    wait(0.2);
    LedVerde = off;
    wait(0.2);
    LedRojo = on;
    wait(0.2);
    LedRojo = off;
    wait(0.2);
    LedAzul = on;
    wait(0.2);
    LedAzul = off;
    wait(0.2);


    // Inicia el ciclo
    while(control) {
waitPulse: // Acá leeríamos los pulsos

        for(i = 0; i <= 3; i++) {
            pulsos();
            pc.printf("Esperando senal de flujo...\r\n");
            if (cPulsos == 3) {
                goto seguir;
            } else goto waitPulse;
        }
seguir:
        bomba++;
        if(bomba == 3) {
            goto recierre;
        } else {
            cPulsos = 0;
            pc.printf("\r\n");
            pc.printf("Se detecta flujo.\r\n");
            LedVerde = on;
            wait(1);
            LedVerde = off;
            goto llenarBalde;
        }



llenarBalde: // Llenar balde donde está la bomba
        int ii = 0;
        while(ii <= limBmax) { // Ciclo para llenar el balde
            if(ii == limBmax) {
                pc.printf("El balde de almacenamiento se ha llenado. Se inicia el bombeo.\r\n");
                goto llenarTanque;
            } else {
                pc.printf("Llenando balde\r\n");
                wait(1);
            }
            ii++;
        }


recierre:
        pc.printf("No hay agua para bombear al tanque.\r\n");
        LedRojo = on;
        wait(2);
        LedRojo = off;
        wait(2);

        pc.printf("Digite f para detectar el flujo, s para salir: ");
        char v = pc.getc();

        switch(v) {
            case 'f':
                bomba = 0;
                goto waitPulse;
                break;
            case 's':
                pc.printf("La bomba se apagara por seguridad.\r\n");
                while(1){
                LedRojo = on;
                wait(0.2);
                LedRojo = off;
                wait(0.2);
                }
                break;
        }


llenarTanque:
        float limTmax = 1;
        for(float l = 0; l <= limTmax; l += 0.033333333) {
            if (l == limTmax) { // Significa que se ha llenado el tanque y se debe alertar.
                pc.printf("Se ha llenado el tanque. Abra la valvula del desague.\r\n");
                goto final;
            } else {
                sendData(l); // Enviar dato a la aplicación de llenado de tanque
            }
        }


final:
        LedRojo = on;
        wait(1);
        LedRojo = off;
        wait(1);

        pc.printf("Digite 'a' para abrir la valvula del tanque: ");
        char c = pc.getc();
        //char c = 'a'; // Agilidad
        pc.printf("\r\n");
        pc.printf("Se inicia la descarga del tanque. \r\n");

        LedVerde = on;
        wait(1);
        LedVerde = off;
        wait(1);
        
        if(c == 'a') {
            float limTmin = 0;
            for(float l1 = 1; l1 >= limTmin; l1 -= 0.033333333) {
                if (l1 == 0) { // Significa que se ha llenado el tanque y se debe alertar.
                    pc.printf("Se ha liberado el tanque. Comprobando flujo...\r\n");
                    wait(1);
                    goto llenarBalde;
                } else {
                    sendData(l1); // Enviar dato a la aplicación de llenado de tanque
                }
            }
        }
    }
}


