#include "mbed.h"
#include "TextLCD.h"
#include "string"
//#include "MSCFileSystem.h"

TextLCD lcd(p15, p16, p10, p11, p12, p13); // rs, e, d4-d7 ;LCD configuration

LocalFileSystem fs("fs");

AnalogOut   aout(p18);                                      //DAC
AnalogIn    ain(p17);                                       //ADC current read
DigitalIn   pb(p9);                                         //Switch
DigitalOut  dout(LED1);                             
DigitalOut  trig(p5);                                       //
DigitalOut  trigstop(p6);                                   //
DigitalOut  trigstart(p7);                                  //
int pbb;

float mini = 0.1f,maxi = 1.2f,stepsize = 0.005f,highV=0,highC=0,readd;
float pulsedur=0.5,step,sample,width=0.25,current,pulseamplitude=0.1;

void lcdprintnum(float number);

int main() {
    lcd.cls();
    pb.mode(PullDown);
    
    while(1){
        pbb=pb;
        trig=0;
        trigstop=0;
        lcd.locate(0,0);  
        lcd.printf("DEVICE READY...");
        
        if(pbb==1){
            FILE *fp = fopen("/fs/test.csv","w");
        
            lcd.cls();
            wait(0.1);
        
            lcd.locate(0,0);  
            lcd.printf("ScanRate:0.01V/s ");
                
                
            for(float i = (mini/3.3); i < (maxi/3.3); i += (stepsize/3.3f)) {
                aout=(i - (pulseamplitude/3.3));    
                trigstart=1;
                trigstart=0;
                trig=0; 
                wait(pulsedur-width);                                      //base voltage duration, sample 1 here
                
                if(i>=1.19/3.3){
                    trigstop=1;        
                } 
                
                aout=i;                                           //pulse voltage 
                lcd.locate(0,1); 
                lcdprintnum(aout.read()*3.3);
                lcd.printf(" V");
                trigstart=1;
                trigstart=0;
                trig=1;
                wait(width);     
                
           //     readd=3.3f*aout.read();
                
            //    if(readd>highC){
            //        highC=readd;          
            //    }
                          
                
                                              //high pulse duration ; pulse = i
            }
            aout=0;  
            lcd.cls();   
            lcdprintnum(readd);
            
            wait(2);
            
        }
    }
}

void lcdprintnum(float number){                     //to display number on lcd
    char aoutstring[10];  
    sprintf(aoutstring,"%.4f",(number));          //convert from float to string to display
    lcd.printf(aoutstring);           
}
                