#include "mbed.h"
#include "getGPS.h"
#include "math.h"

Serial pc(USBTX,USBRX);
GPS gps (p28,p27);
Serial xbee(p13,p14);


int main() {
     double a;
     double b;
     double distance;
    
    pc.printf("GPS Start\n");
    xbee.printf("s\n");
     while(1) {
         if(gps.getgps()){
           a = gps.latitude;
           b = gps.longitude;
           
          pc.printf("(%lf,%lf)\r\n",gps.latitude,gps.longitude);//緯度と経度を表示   
           break;
           
         }else{
          pc.printf("NO DATA\r\n");//データ取得失敗
          wait(1);
            }
       }
      while(1){
         if(gps.getgps()) {
           
          pc.printf("(%lf,%lf)\n\r",gps.latitude,gps.longitude);//緯度と経度を表示   
          
       // 球面三角法により、大円距離(メートル)を求める
       double c;
       double d; 
        c = gps.latitude;
        d = gps.longitude;

         const double pi = 3.14159265359; // 円周率
                           
            double ra = a * pi / 180;
            double rb = b * pi / 180;     // 緯度経度をラジアンに変換
            double rc = c * pi / 180;
            double rd = d * pi / 180;
        
            double e = sin(ra) * sin(rc) +  cos(ra) * cos(rc) * cos(rb - rd);  // 2点の中心角(ラジアン)を求める
            double rr = acos(e);

            const double earth_radius = 6378140;   // 地球赤道半径(m)

            distance = earth_radius * rr; // 2点間の距離(m)
             

         if (distance<5){
             }else{
             pc.printf("5m clear!");
             xbee.printf("5m clear!");
             break;
              }
          
          }else{
           xbee.printf("NO DATA\r\n");//データ取得失 
           pc.printf("NO DATA\r\n");  
           wait(1);
           }
        }
        return 0;
     }
     
     
     
     
     
    

