#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"


// USB serial (tx, rx)
Serial pc(USBTX, USBRX);

// SD card
SDFileSystem sd(p5, p6, p7, p8, "sd");

// Audio out (PWM)
//PwmOut       PWMout_pin(p26);
//wave_player  waver(&PWMout_pin);

AnalogOut       DACout(p18);
wave_player     waver(&DACout);

void playSong()
{
    FILE *file;

    // Open sound file for reading
    file = fopen("/sd/sound_files/2001_A_Space_Odyssey_DownSampled.wav", "r");
    if ( file == NULL ) {
        error("ERROR: Could not open file for reading!\n");
    }

    // Play the sound file
    pc.printf("Playing sound clip \r\n");
    waver.play(file);

    // Reset to beginning of file and close it
    fseek(file, 0, SEEK_SET);
    fclose(file);

}

int main() {
    while(1) {
        playSong();
        wait(0.01);
    }
}
