/* mbed NokiaLCD Library, for a 130x130 Nokia colour LCD
 * Copyright (c) 2007-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MoledH
#define MoledH

#include "mbed.h"

/** An interface for the 130x130 Nokia Mobile phone screens
 *
 * @code
 * #include "mbed.h"
 * #include "Moled.h"
 *
 * Moled lcd(p5, p7, p8, p9); // mosi, sclk, cs, rst
 *
 * int main() {
 *     lcd.printf("Hello World!");
 * }
 */
class Moled : public Stream {

public:
    /** Create and Nokia LCD interface, using a SPI and two DigitalOut interfaces
     *
     * @param mosi SPI data out
     * @param sclk SPI clock
     * @param cs Chip Select (DigitalOut)
     * @param rst Reset (DigitalOut)
     * @param type The LCDType to select driver chip variants
     */
Moled(PinName mosi, PinName sclk, PinName cs, PinName rst, PinName power);
    /** General parameters for MARMEX_OB_oled */
     enum  {
         ROWS          = 15,         /**< # of rows (lines) for displaying characters  */
         COLS          = 16,         /**< # of columns (width) for displaying characters  */
         WIDTH         = 128,        /**< screen width [pixels]  */
         HEIGHT        = 128,        /**< screen height [pixels]  */
         SPI_FREQUENCY = 20000000    /**< SPI (sclk) SPI_FREQUENCY  */
     };

    /** Constants for power() function */
    enum  {
        OFF   = 0,  /**< : to turning-OFF  */
        ON          /**< : to turning-ON   */
    };

#if DOXYGEN_ONLY
    /** Write a character to the LCD
     *
     * @param c The character to write to the display
     */
    int putc(int c);

    /** Write a formated string to the LCD
     *
     * @param format A printf-style format string, followed by the
     *               variables to use in formating the string.
     */
    int printf(const char* format, ...);
#endif

    /** Locate to a screen column and row
     *
     * @param column  The horizontal position from the left, indexed from 0
     * @param row     The vertical position from the top, indexed from 0
     */
    void locate(int column, int row);

   /** font size
    * void Moled::fontsize(int yoko,int tate){
    * 
    * @param yoko   The vertical multiply factor
    * @param tate   The horizotal multiply factor
    */
    void fontsize(int yoko,int tate);


    /** Clear the screen and locate to 0,0 */
    void cls();

    void pixel(int x, int y, int colour);
    void fill(int x, int y, int width, int height, int colour);

    void blit(int x, int y, int width, int height, const int* colour);
    void bitblit(int x, int y, int width, int height, const char* bitstream);

    int width();
    int height();
    int columns();
    int rows();

    void reset();

    void foreground(int c);
    void background(int c);

private: //protected:
    /** Command list for the OLED controller */
    enum {
        SET_DISPLAY_MODE_ALL_OFF                = 0xA4,
        SET_COMMAND_LOCK                        = 0xFD,
        SET_SLEEP_MODE_ON                       = 0xAE,
        FRONT_CLOCK_DRIVER_OSC_FREQ             = 0xB3,
        SET_MUX_RATIO                           = 0xCA,
        SET_DISPAY_OFFSET                       = 0xA2,
        SET_DISPAY_START_LINE                   = 0xA1,
        SET_REMAP_COLOR_DEPTH                   = 0xA0,
        SET_GPIO                                = 0xB5,
        FUNCTION_SELECTION                      = 0xAB,
        SET_SEGMENT_LOW_VOLTAGE                 = 0xB4,
        SET_CONTRAST_CURRENT_FOR_COLOR_ABC      = 0xC1,
        MASTER_CONTRAST_CURRENT_CONTROL         = 0xC7,
        LOOKUP_TABLE_FOR_GRAYSCALE_PULSE_WIDTH  = 0xB8,
        SET_RESET_PRECHARGE_PERIOD              = 0xB1,
        ENHANCE_DRIVING_SCHEME_CAPABILITY       = 0xB2,
        SET_PRECHARGE_VOLTAGE                   = 0xBB,
        SET_SECOND_PRECHARGE_VOLTAGE            = 0xB6,
        SET_VCOMH_VOLTAGE                       = 0xBE,
        SET_DISPLAY_MODE_RESET                  = 0xA6,
        SET_COLUMN_ADDRESS                      = 0x15,
        SET_ROW_ADDRESS                         = 0x75,
        WRITE_RAM_COMMAND                       = 0x5C,
        SET_SLEEP_MODE_OFF                      = 0xAF
    };
protected:

    virtual void _window(int x, int y, int width, int height);
    virtual void _putp(int colour);

    void command(int value);
    void data(int value);

    void newline();
    virtual int _putc(int c);
    virtual int _getc() {
        return 0;
    }
    void putp(int v);
    void window(int x, int y, int width, int height);
    //void power( unsigned char sw );

    SPI _spi;
    DigitalOut _rst;
    DigitalOut _cs;
    DigitalOut _power;

    //LCDType _type;
    int _row, _column, _rows, _columns, _foreground, _background, _width, _height;
    int _yokosize, _tatesize;
    
    unsigned int findface(unsigned short c);
};

#endif //Moled


