/* mbed Nokia LCD Library
 * Copyright (c) 2007-2010, sford
 */

#include "Moled.h"
#include "small_font.h"
#include "mbed.h"

#define Moled_ROWS 15
#define Moled_COLS 16
#define Moled_WIDTH 128
#define Moled_HEIGHT 128
#define Moled_FREQUENCY 20000000

#define countof(x) ( sizeof(x) / sizeof(x[0]) ) //for Japanese

    /** Constants for power() function */
    enum  {
        OFF   = 0,  /**< : to turning-OFF  */
        ON          /**< : to turning-ON   */
    };


bool kstate = false;           //for Japnaese
unsigned int kbuf;             //for Japanese

Moled::Moled(PinName mosi, PinName sclk, PinName cs, PinName rst, PinName power)
        : _spi(mosi, NC, sclk)
        , _rst(rst)
        , _cs(cs) 
        , _power(power){
    //power( ON );
    _power=1;
    _row = 0;
    _column = 0;
    _foreground = 0x00FFFFFF;
    _background = 0x00000000;
    _yokosize = 1; //1:8x8 2:bai x bai
    _tatesize = 1;//
    reset();
}

void Moled::reset() {

   #define GAMMA_LUT_SIZE 63
        unsigned char    gamma_LUT[ GAMMA_LUT_SIZE ];
        
        for ( int i = 0; i < GAMMA_LUT_SIZE; i++ )
            gamma_LUT[ i ]  = (unsigned char)(powf( ((float)i / 62.0), (1.0 / 0.58) ) * 178.0 + 2.0);

    // setup the SPI interface and bring display out of reset

    _cs = 1;
    _rst = 0;
    _spi.format(9);                      wait_ms(10);
    _spi.frequency(Moled_FREQUENCY);     wait_ms(10);
    _rst = 1;                            wait_ms(10);

    _cs = 0;

   //initalize
   _power=0;
        command( SET_DISPLAY_MODE_ALL_OFF );
        command( SET_COMMAND_LOCK );
        data( 0x12 );

        command( SET_COMMAND_LOCK );
        data( 0xb1 );

        command( SET_SLEEP_MODE_ON );

        command( FRONT_CLOCK_DRIVER_OSC_FREQ );
        data( 0xF1 );

        command( SET_MUX_RATIO );
        data( 0x7F );

        command( SET_DISPAY_OFFSET );
        data( 0x00 );

        command( SET_DISPAY_START_LINE );
        data( 0x00 );

        command( SET_REMAP_COLOR_DEPTH );
        data( 0x74 );

        command( SET_GPIO );
        data( 0x00);

        command( FUNCTION_SELECTION );
        data( 0x01 );

        command( SET_SEGMENT_LOW_VOLTAGE );
        data( 0xA0 );
        data( 0xB5 );
        data( 0x55 );

        command( SET_CONTRAST_CURRENT_FOR_COLOR_ABC );
        data( 0xC8 );
        data( 0x80 );
        data( 0xC8 );

        command( MASTER_CONTRAST_CURRENT_CONTROL );
        data( 0x0F );

        command( LOOKUP_TABLE_FOR_GRAYSCALE_PULSE_WIDTH );
        for ( int i = 0; i < GAMMA_LUT_SIZE; i++ )
            data(  gamma_LUT[ i ] );

        command( SET_RESET_PRECHARGE_PERIOD );
        data( 0x32 );

        command( ENHANCE_DRIVING_SCHEME_CAPABILITY );
        data( 0x04 );
        data( 0x00 );
        data( 0x00 );

        command( SET_PRECHARGE_VOLTAGE );
        data( 0x17 );

        command( SET_SECOND_PRECHARGE_VOLTAGE );
        data( 0x01 );

        command( SET_VCOMH_VOLTAGE );
        data( 0x05 );

        command( SET_DISPLAY_MODE_RESET );

#if 0
        command( SET_COLUMN_ADDRESS );
        data( 0x00 );
        data( 0x7F );

        command( SET_ROW_ADDRESS );
        data( 0x00 );
        data( 0x7F);

        command( WRITE_RAM_COMMAND );
        for ( int i = 0; i < WIDTH * HEIGHT; i++ )
            data( 0x00 );
#endif
        //cls();
        _power=1;
        wait_ms( 200 );
        command( SET_SLEEP_MODE_OFF );

//        _cs = 1;

} // void Moled::reset() 


void Moled::command(int value) {
    _spi.write(value & 0xFF);
}

void Moled::data(int value) {
    _spi.write(value | 0x100);
}

void Moled::_window( int x, int y, int width, int height ) {
        int x1 = x + 0;
        int y1 = y + 0;
        int x2 = x1 + width - 1;
        int y2 = y1 + height - 1;

        command( SET_COLUMN_ADDRESS );
        data( x1 );
        data( x2 );
        command( SET_ROW_ADDRESS );
        data( y1 );
        data( y2 );
        command( WRITE_RAM_COMMAND );
}
void Moled::window( int x, int y, int width, int height ) {
        _cs = 0;
        _window( x, y, width, height );
        _cs = 1;
}

void Moled::_putp(int colour) {

        int cnv = 0;

        cnv  = (colour >> 8) & 0xf800;
        cnv |= (colour >> 5) & 0x07e0;
        cnv |= (colour >> 3) & 0x001f;

        data( cnv >> 8);
        data( cnv );
}


void Moled::locate(int column, int row) {
    _column = column;
    _row = row;
}
void Moled::fontsize(int yoko,int tate){
    _yokosize=yoko;
    _tatesize=tate;
}

void Moled::newline() {
    _column = 0;
    _row++;
    if (_row >= Moled_ROWS) {
        _row = 0;
    }
}

unsigned int Moled::findface(unsigned short c) {
    unsigned int p = 0;
    int i, sum;
    for (sum = i = 0; i < countof(font8table); i++) {
        if (font8table[i].start <= c && c <= font8table[i].end) {
            p = (sum + c - font8table[i].start);
            break;
        }
        sum += font8table[i].end - font8table[i].start + 1;
    }
    return p;
}

int Moled::_putc(int value) {
    int x = _column * 8 ;  // FIXME: Char sizes
    int y = _row * 8;

    if(value == '\n') {
        newline();
    } else if (kstate) { // 2nd byte of shift-jis
        kstate = false;
        int p = findface(kbuf << 8 | value);
        bitblit(x + 1, y + 1, 8,8, (char*)&(FontLookup[p][0]));

           //printf("%x %x",( kbuf << 8 | value),p); //for debug
        _column++;
        if (_column >= Moled_COLS) {
            _row++;
            _column = 0;
        }
        if (_row >= Moled_ROWS) {
            _row = 0;
        }
    } else if ((0x81 <= value && value <= 0x9f) || (0xe0 <= value && value <= 0xfc)) { // 1st byte of shift-jis
        kstate = true;
        kbuf = value;
    } else {
        bitblit(x + 1, y + 1, 8, 8, (char*)&(FontLookup_ABC[value-32][0]));
        _column++;
        if (_column >= Moled_COLS) {
            _row++;
            _column = 0;
        }
        if (_row >= Moled_ROWS) {
            _row = 0;
        }
    }

    return value;
}

void Moled::cls() {
    fill(0, 0, Moled_WIDTH, Moled_HEIGHT, _background);
    _row = 0;
    _column = 0;
}

void Moled::putp(int colour) {
    _cs = 0;
    _putp(colour);
    _cs = 1;
}

void Moled::pixel(int x, int y, int colour) {
    _cs = 0;
    _window(x, y, 1, 1);
    _putp(colour);
    _cs = 1;
}

void Moled::fill(int x, int y, int width, int height, int colour) {
    _cs = 0;
    _window(x, y, width, height);
    for (int i=0; i<width*height; i++) {
        _putp(colour);
    }
    _window(0, 0, Moled_WIDTH, Moled_HEIGHT);
    _cs = 1;
}

void Moled::blit(int x, int y, int width, int height, const int* colour) {
    _cs = 0;
    _window(x, y, width, height);
    for (int i=0; i<width*height; i++) {
        _putp(colour[i]);
    }
    _window(0, 0, Moled_WIDTH, Moled_HEIGHT);
    _cs = 1;
}

void Moled::bitblit(int x, int y, int width, int height, const char* bitstream) {
/*
    _cs = 0;
    _window(x, y, width*2, height);  //add *2
    for (int i=0; i<height*width; i++) {
        int byte = i / 8;
        int bit = i % 8;
        int colour = ((bitstream[byte] << bit) & 0x80) ? _foreground : _background;
       _putp(colour);  // add shu 7/17
       _putp(colour);
    }
    _window(0, 0, _width, _height);
    _cs = 1;
*/
    _cs = 0;
    int ii=0;
    _window(x*_yokosize, y*_tatesize, width*_yokosize, height*_tatesize);  //add *2
    for (int i=0; i<height*_tatesize; i++) {
    ii=i/_tatesize;
        for (int j=0;j<width;j++){
            int byte = (ii*width+j) / 8;
            int bit =  (ii*width+j) % 8;
            int colour = ((bitstream[byte] << bit) & 0x80) ? _foreground : _background;
           for (int jj=0;jj<_yokosize;jj++){
           _putp(colour);
           } 
        }

      }
}
 

void Moled::foreground(int c) {
    _foreground = c;
}

void Moled::background(int c) {
    _background = c;
}

int Moled::width() {
    return Moled_WIDTH;
}

int Moled::height() {
    return Moled_HEIGHT;
}

int Moled::columns() {
    return Moled_COLS;
}

int Moled::rows() {
    return Moled_ROWS;
}
