/* Copyright (c) 2014 Shigenori Inoue, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __PseudoRTC__
#define __PseudoRTC__

#include "mbed.h"

/**  Example:
 * @code
 * #include "mbed.h"
 * #include "PseudoRTC.h"
 *
 * PseudoRTC c;
 *
 * main()
 * {
 *     /* Example: September 20, 2014, 21:05:30
 *     c.setTime(2014, 09, 20, 21, 05, 30);
 * 
 *     while(true) {
 *         printf("%04d/%02d/%02d %02d:%02d:%02d\r\m", c.getYear(), c.getMonth(), c.getDay(), c.getHour(), c.getMinute(), c.getSecond());
 *         wait(1);
 *     }
 * }
 * @endcode
 */

class PseudoRTC
{
public:
    /** Create a pseudo real-time clock */
    PseudoRTC(void);

    ~PseudoRTC(void);

    /** Set time in the pseudo real-time clock
     * @param y Year
     * @param mo Month
     * @param d Day
     * @param h Hour
     * @param m Minute
     * @param s Second
     */
    void setTime(int y, int mo, int d, int h, int mi, int s);

    /** Get the year value */
    int getYear(void);

    /** Get the month value */
    int getMonth(void);

    /** Get the day value */
    int getDay(void);

    /** Get the hour value */
    int getHour(void);

    /** Get the minute value */
    int getMinute(void);

    /** Get the second value */
    int getSecond(void);

private:
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
    Ticker t;
    void tictoc(void);
};

#endif