/*
 * A program for the use of the DHT11, a temperature and humidity sensor
 * Shigenori Inoue, September 10, 2014
 */
 
#include "mbed.h"
#include "TextLCD.h"
#include "DHT11.h"

// LEDs for debugging
BusOut leds(LED4, LED3, LED2, LED1);

// LCD module
TextLCD lcd(p25, p24, p12, p13, p14, p23);

// Humidity sensor
DHT11 d(p18);

// The main function
int main()
{
    int state;

    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("DHT11 Humidity");

    while(true) {
        state = d.readData();

        if (state != DHT11::OK) {
            lcd.locate(0, 1);
            lcd.printf("Error: %d", state);
        } else {
            lcd.locate(0, 1);
            lcd.printf("T: %dC, H: %d%%", d.readTemperature(), d.readHumidity());
        }
        leds = leds + 1;
        wait(2.0);
    }
}
