/* Copyright (c) 2014 Shigenori Inoue, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "TextLCD.h"
#include "AM2303.h"

/* LEDs for debugging */
BusOut leds(LED4, LED3, LED2, LED1);

/* LCD module */
TextLCD lcd(p25, p24, p12, p13, p14, p23);

/* Humidity sensor */
AM2303 h(p18);

/* The main function */
int main()
{
    /* Variables */
    int state;

    /* Show splash screen */
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("AM2303 Humidity");

    /* Infinate loop */
    while(true) {
        /* Wait for measurement */
        wait(2.0);

        /* Read the measured results */
        state = h.readData();

        /* Show the data, otherwise error */
        lcd.locate(0, 1);
        if (state != AM2303::OK) {
            lcd.printf("<Error: %d>", state);
        } else {
            lcd.printf("T:%2.1fC, H:%2.1f%%", h.readTemperature(), h.readHumidity());
        }

        /* Blink LED for Debug */
        leds = leds + 1;
    }
}
