/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "C12832.h"

Serial pc(USBTX, USBRX);
// Joystick Pins
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn fire(D4);

// Screen
C12832 lcd(D11, D13, D12, D7, D10);

// PWMs
AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

// RGB leds
PwmOut r (D5);
PwmOut g (D8);
PwmOut b (D9);

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500


int main()
{
    int colorChoice = 0;
    
    while(true)
    {
        pc.printf("Pot 1 = %.2f\n", (float)pot1);
        pc.printf("Pot 2 = %.2f\n", (float)pot2);
     
        
        r = pot1;
        g = pot2;
        b = pot2;
        wait(1.0);
    }
    
}
