//Program: light show Booth
//Author: Spencer Booth
//Date: 22 Feb 2015
//Description: this program will allow the user to change the LED
//             flash pattern as well as flash speed and brightness.

//preproccesor statements
#include "mbed.h"
#include "tsi_sensor.h"

//setting my inputs for the switches and slider
DigitalIn Switch1(PTD5); // push button switches on the protoboard
DigitalIn Switch2(PTA13);
DigitalIn Switch3(PTC9);
DigitalIn Switch4(PTC8);

PwmOut ProtoBoardRed(PTA4); // protoboard LED outputs
PwmOut ProtoBoardGreen(PTD4);
PwmOut ProtoBoardYellow(PTA12);

PwmOut Green(LED_GREEN);        // PWM outputs tied to MBED LEDs
PwmOut Red(LED_RED);            
PwmOut Blue(LED_BLUE);
AnalogIn Potentiometer(A0); // LED brightness controller

TSIAnalogSlider tsi(PTB16,PTB17,50);// LED flash speed controller

int main() 
{
    while(1)
    {
    if(Switch1 == 0) // flash pattern for when switch 1 is pressed
        {
        ProtoBoardRed = Potentiometer;
        ProtoBoardGreen = Potentiometer;
        ProtoBoardYellow = Potentiometer;
        wait(1 - tsi.readPercentage() );
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = 0;
        wait(1 - tsi.readPercentage() );
        }
    else if(Switch2 == 0) // flash pattern for when switch 2 is pressed
        {
        ProtoBoardRed = Potentiometer;
        ProtoBoardGreen = Potentiometer;
        ProtoBoardYellow = 0;   
        wait(1 - tsi.readPercentage() );
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = Potentiometer;   
        wait(1 - tsi.readPercentage() );        
        }
    else if(Switch3 == 0)// flash pattern for when switch 3 is pressed
        {
        ProtoBoardRed = Potentiometer;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = 0;   
        wait(1 - tsi.readPercentage() );
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = Potentiometer;
        ProtoBoardYellow = 0;   
        wait(1 - tsi.readPercentage() );
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = Potentiometer;   
        wait(1 - tsi.readPercentage() );
        }
    else if(Switch4 == 0)// flash pattern for when switch 4 is pressed(combination of the last 3 switches patterns)
        {
        Red = 1;
        
        ProtoBoardRed = Potentiometer;
        ProtoBoardGreen = Potentiometer;
        ProtoBoardYellow = Potentiometer;
        wait(1 - tsi.readPercentage() );
        Red = 0;
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = 0;            
        wait(1 - tsi.readPercentage() );
        Blue = 1;
        
        ProtoBoardRed = Potentiometer;
        ProtoBoardGreen = Potentiometer;
        ProtoBoardYellow = 0;   
        wait(1 - tsi.readPercentage() );
        Blue = 0;
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = Potentiometer;   
        wait(1 - tsi.readPercentage() );
        Green = 1;
        
        ProtoBoardRed = Potentiometer;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = 0;   
        wait(1 - tsi.readPercentage() );
        Green = 0;
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = Potentiometer;
        ProtoBoardYellow = 0;   
        wait(1 - tsi.readPercentage() );
        Red = 1;
        Blue = 1;
        Green = 1;
        
        ProtoBoardRed = 0;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = Potentiometer;   
        wait(1 - tsi.readPercentage() );
        Red = 0;
        Blue = 0;
        Green = 0;  
        }
    else    // if no button is pressed, no lights will be on.
        {
        ProtoBoardRed = 0;
        ProtoBoardGreen = 0;
        ProtoBoardYellow = 0;   
        Red = 0;
        Blue = 0;
        Green = 0;              
        }
    }
}
