#pragma once

#include "ISPICommand.h"
#include "mbed.h"

class MbedSPICommand : public ISPICommand
{
public:
    MbedSPICommand(PinName mosi, PinName miso, PinName sck, PinName cs);

    virtual void SetMaxFrequency(int frequency);

    virtual void Write(int command);
    virtual void Write(int command, const void* pParam, int length);
    virtual void Read(int command, void* pReaded, int readLength);
    virtual void Read(int command, const void* pParam, int paramLength, void* pReaded, int readLength);

private:
    SPI _spi;
    DigitalOut _cs;
};

