#include "mbed.h"
#include "MbedSPICommand.h"
#include "SerialFlashDeviceCreator.h"

DigitalOut myled(LED1);

int main()
{
    ISPICommand* pSPICommand = new MbedSPICommand(p11, p12, p13, p14);   // MOSI, MISO, SCK, CS

    ISerialFlashDevice* pDevice = SerialFlashDeviceCreator::Create(pSPICommand);
    if (pDevice == NULL)
    {
        printf("Unsupported device");
        return;
    }
    printf("%s\n", pDevice->GetDeviceName());
    printf("%dK x 8\n", pDevice->GetCapacity() / 1024);

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
