#include "MbedSPICommand.h"

MbedSPICommand::MbedSPICommand(PinName mosi, PinName miso, PinName sck, PinName cs)
 : _spi(mosi, miso, sck)
 , _cs(cs)
{
    //CS inactive
    _cs = 1;
}

void MbedSPICommand::SetMaxFrequency(int frequency)
{
    static const int LPC1768MaxFrequency = 46000000;

    if (frequency > LPC1768MaxFrequency)
    {
        frequency = LPC1768MaxFrequency;
    }
    _spi.frequency(frequency);
}

void MbedSPICommand::Write(int command)
{
    _cs = 0;
    _spi.write(command);
    _cs = 1;
}

void MbedSPICommand::Write(int command, const void* pParam, int length)
{
    _cs = 0;
    _spi.write(command);

    const char*p = static_cast<const char*>(pParam);
    for (int i = 0; i < length; ++i)
    {
        _spi.write(*p++);
    }
    _cs = 1;
}

void MbedSPICommand::Read(int command, void* pReaded, int readLength)
{
    _cs = 0;
    _spi.write(command);
    
        char* pReadedByte = static_cast<char*>(pReaded);
    for (int i = 0; i < readLength; ++i)
    {
        *pReadedByte++ = _spi.write(0xff);
    }
    _cs = 1;
}

void MbedSPICommand::Read(int command, const void* pParam, int paramLength, void* pReaded, int readLength)
{
    _cs = 0;
    _spi.write(command);
    
    const char* pParamByte = static_cast<const char*>(pParam);
    for (int i = 0; i < paramLength; ++i)
    {
        _spi.write(*pParamByte++);
    }
    char* pReadedByte = static_cast<char*>(pReaded);
    for (int i = 0; i < readLength; ++i)
    {
        *pReadedByte++ = _spi.write(0xff);
    }
    _cs = 1;
}
