#include "ISerialFlashDevice.h"
#include "SST25Device.h"
#include "M25PDevice.h"
#include "SerialFlashDeviceCreator.h"

ISerialFlashDevice* SerialFlashDeviceCreator::Create(ISPICommand* pSPICommand)
{
    if (M25PDevice::IsSupported(pSPICommand))
    {
        return M25PDevice::Create(pSPICommand);
    }
    if (SST25Device::IsSupported(pSPICommand))
    {
        return SST25Device::Create(pSPICommand);
    }
    return NULL;
}
