#pragma once

#include <string>

class ISPICommand;

class SST25DeviceImpl
{
public:
    static bool IsSupported(ISPICommand* pSPICommand);
    static SST25DeviceImpl* Create(ISPICommand* pSPICommand);
    ~SST25DeviceImpl(void);
    
    std::string GetDeviceName() const;
    int GetCapacity() const;
    int Read(int address, void* buffer, int length);
    int Write(int address, const void* buffer, int length);
    void ChipErase(void);

private:
    ISPICommand* const _pSPICommand;
    int _operationFrequency;
    struct DeviceProperty
    {
        std::string deviceName;
        int  capacity;
        int  blockProtectionMask;
        int  pageSize;
        void (SST25DeviceImpl::*pfnWriter)(int address, const void* buffer, int length);

        int  operationClkHz;        
    } const& _property;
    static const DeviceProperty* findMatchDevice(ISPICommand* pSPICommand);

    SST25DeviceImpl(ISPICommand* pSPICommand, const DeviceProperty& property);
    static void readId(ISPICommand* pSPICommand, int& manufacturersId, int& deviceId);
    static void fillAddress(char* pBuffer, int address);

    int readStatusRegister(void);
    void writeStatusRegister(int value);
    void writeEnable(void);
    void writeDisable(void);
    void waitForReady(void);

    void byteProgram(int address, int value);
    void pageProgram(int address, const void* buffer);
    void beginAAIProgram(int address, int data);
    void nextAAIProgram(int data);
    void endAAIProgram(void);
    void beginAAIWordProgram(int address, int data);
    void nextAAIWordProgram(int data);

    void writeBytes(int address, const void* buffer, int length);
    void writeAAI(int address, const void* buffer, int length);
    void writeAAIWord(int address, const void* buffer, int length);
    void writePage(int address, const void* buffer, int length);
};
