#pragma once

#include <memory>
#include <string>
#include "ISerialFlashDevice.h"

class ISPICommand;
class SST25DeviceImpl;

class SST25Device : public ISerialFlashDevice
{
public:
    static SST25Device* Create(ISPICommand* pSPICommand);
    static bool IsSupported(ISPICommand* pSPICommand);

    virtual std::string GetDeviceName(void) const;
    virtual int GetCapacity(void) const;
    virtual void ChipErase(void);
    virtual int Read(int address, void* buffer, int length);
    virtual int Write(int address, const void* buffer, int length);

private:
    std::auto_ptr<SST25DeviceImpl> _pImpl;
    SST25Device(SST25DeviceImpl* pImpl);
};
