#include "mbed.h"
#include "SST25DeviceImpl.h"
#include "SST25Device.h"

bool SST25Device::IsSupported(ISPICommand* pSPICommand)
{
    return SST25DeviceImpl::IsSupported(pSPICommand);
}

SST25Device* SST25Device::Create(ISPICommand* pSPICommand)
{
    SST25DeviceImpl* pImpl = SST25DeviceImpl::Create(pSPICommand);
    if (pImpl == NULL)
    {
        return NULL;
    }
    return new SST25Device(pImpl);
}


SST25Device::SST25Device(SST25DeviceImpl* pImpl)
 : _pImpl(pImpl)
{

}

string SST25Device::GetDeviceName(void) const
{
    return _pImpl->GetDeviceName();
}

int SST25Device::GetCapacity(void) const
{
    return _pImpl->GetCapacity();
}

void SST25Device::ChipErase(void)
{
    _pImpl->ChipErase();
}

int SST25Device::Read(int address, void* buffer, int length)
{
    return _pImpl->Read(address, buffer, length);
}

int SST25Device::Write(int address, const void* buffer, int length)
{
    return _pImpl->Write(address, buffer, length);
}
