#pragma once

#include <string>

class ISPICommand;

class M25PDeviceImpl
{
public:
    static bool IsSupported(ISPICommand* pSPICommand);
    static M25PDeviceImpl* Create(ISPICommand* pSPICommand);
    ~M25PDeviceImpl(void);
    
    std::string GetDeviceName() const;
    int GetCapacity() const;
    int Read(int address, void* buffer, int length);
    int Write(int address, const void* buffer, int length);
    void BulkErase(void);

private:
    ISPICommand* _pSPICommand;
    int _operationFrequency;
    struct DeviceProperty
    {
        std::string deviceName;
        int  capacity;
        int  blockProtectionMask;
    } const& _property;
    static const DeviceProperty* findMatchDevice(ISPICommand* pSPI);

    M25PDeviceImpl(ISPICommand* pSPICommand, const DeviceProperty& property);
    static void readId(ISPICommand* pSPICommand, int& manufacturerId, int& memoryType, int& memoryCapacity);
    static void fillAddress(char* pBuffer, int address);

    int readStatusRegister(void);
    void clearBlockProtection(void);
    void writeStatusRegister(int value);
    void writeEnable(void);
    void writeDisable(void);
    void pageProgram(int address, const void* buffer);
};
