#pragma once

#include <memory>
#include <string>
#include "ISerialFlashDevice.h"

class ISPICommand;
class M25PDeviceImpl;

class M25PDevice : public ISerialFlashDevice
{
public:
    static M25PDevice* Create(ISPICommand* pSPICommand);
    static bool IsSupported(ISPICommand* pSPICommand);

    virtual std::string GetDeviceName(void) const;
    virtual int GetCapacity(void) const;
    virtual void ChipErase(void);
    virtual int Read(int address, void* buffer, int length);
    virtual int Write(int address, const void* buffer, int length);

private:
    std::auto_ptr<M25PDeviceImpl> _pImpl;
    M25PDevice(M25PDeviceImpl* pImpl);
};
