#include "mbed.h"
#include "M25PDeviceImpl.h"
#include "M25PDevice.h"

bool M25PDevice::IsSupported(ISPICommand* pSPICommand)
{
    return M25PDeviceImpl::IsSupported(pSPICommand);
}

M25PDevice* M25PDevice::Create(ISPICommand* pSPICommand)
{
    M25PDeviceImpl* pImpl = M25PDeviceImpl::Create(pSPICommand);
    if (pImpl == NULL)
    {
        return NULL;
    }
    return new M25PDevice(pImpl);
}


M25PDevice::M25PDevice(M25PDeviceImpl* pImpl)
 : _pImpl(pImpl)
{

}

string M25PDevice::GetDeviceName(void) const
{
    return _pImpl->GetDeviceName();
}

int M25PDevice::GetCapacity(void) const
{
    return _pImpl->GetCapacity();
}

void M25PDevice::ChipErase(void)
{
    _pImpl->BulkErase();
}

int M25PDevice::Read(int address, void* buffer, int length)
{
    return _pImpl->Read(address, buffer, length);
}

int M25PDevice::Write(int address, const void* buffer, int length)
{
    return _pImpl->Write(address, buffer, length);
}
