#pragma once

#include <string>

class ISerialFlashDevice
{
public:
    virtual ~ISerialFlashDevice(void) { }
    virtual std::string GetDeviceName(void) const = 0;
    virtual int GetCapacity(void) const = 0;
    virtual void ChipErase(void) = 0;
    virtual int Read(int address, void* buffer, int length) = 0;
    virtual int Write(int address, const void* buffer, int length) = 0;
};
