/*****************************************************************************
 * Project      : 7" TFT LCD 800x480 [AT070TN92]
 * Compiler     : mbed Online
 * Type         : Libraries
 * Comment      : Support mbed ST Nucleo Board.
 *              : Support Chip = SSD1963
 * File         : SSD1963.h
 *
 * Author       : Mr.Thongchai Artsamart [Bird Techstep]
 * E-Mail       : t.artsamart@gmail.com
 *              : tbird_th@hotmail.com
 * Start Date   : 20/03/2014 [dd/mm/yyyy]
 * Version Date : 20/03/2014 [dd/mm/yyyy]
 * Licensed under a Creative Commons Attribution-ShareAlike 3.0 License.
 *****************************************************************************
 * Remark    : Thank you -. no1wudi [CooCox]
 *                       -.
 *****************************************************************************/
#ifndef __SSD1963_H_
#define __SSD1963_H_
#include "lcd_base.h"

    /*********************************************************************
    * Overview: Image orientation (can be 0, 90, 180, 270 degrees).
    *********************************************************************/  
    #define DISP_ORIENTATION    0
    /*********************************************************************
    * Overview: Panel Data Width (R,G,B) in (6,6,6)
    *********************************************************************/
    #define DISP_DATA_WIDTH             18
    /*********************************************************************
    * Overview: Horizontal and vertical display resolution
    *                  (from the glass datasheet).
    *********************************************************************/
    #define DISP_HOR_RESOLUTION 480
    #define DISP_VER_RESOLUTION 272
    /*********************************************************************
    * Overview: Horizontal synchronization timing in pixels
    *                  (from the glass datasheet).
    *********************************************************************/
    #define DISP_HOR_PULSE_WIDTH        1
    #define DISP_HOR_BACK_PORCH         210
    #define DISP_HOR_FRONT_PORCH        45  
    /*********************************************************************
    * Overview: Vertical synchronization timing in lines
    *                  (from the glass datasheet).
    *********************************************************************/
    #define DISP_VER_PULSE_WIDTH        1
    #define DISP_VER_BACK_PORCH         34  
    #define DISP_VER_FRONT_PORCH        10

/*********************************************************************
* Overview: Some basic colors definitions.
*********************************************************************/
#define BLACK               RGB565CONVERT(0,    0,      0)
#define BRIGHTBLUE          RGB565CONVERT(0,    0,      255)
#define BRIGHTGREEN         RGB565CONVERT(0,    255,    0)
#define BRIGHTCYAN          RGB565CONVERT(0,    255,    255)
#define BRIGHTRED           RGB565CONVERT(255,  0,      0)
#define BRIGHTMAGENTA       RGB565CONVERT(255,  0,      255)
#define BRIGHTYELLOW        RGB565CONVERT(255,  255,    0)
#define BLUE                RGB565CONVERT(0,    0,      128)
#define GREEN               RGB565CONVERT(0,    128,    0)
#define CYAN                RGB565CONVERT(0,    128,    128)
#define RED                 RGB565CONVERT(128,  0,      0)
#define MAGENTA             RGB565CONVERT(128,  0,      128)
#define BROWN               RGB565CONVERT(255,  128,    0)
#define LIGHTGRAY           RGB565CONVERT(128,  128,    128)
#define DARKGRAY            RGB565CONVERT(64,   64,     64)
#define LIGHTBLUE           RGB565CONVERT(128,  128,    255)
#define LIGHTGREEN          RGB565CONVERT(128,  255,    128)
#define LIGHTCYAN           RGB565CONVERT(128,  255,    255)
#define LIGHTRED            RGB565CONVERT(255,  128,    128)
#define LIGHTMAGENTA        RGB565CONVERT(255,  128,    255)
#define YELLOW              RGB565CONVERT(255,  255,    128)
#define WHITE               RGB565CONVERT(255,  255,    255)
                            
#define GRAY0               RGB565CONVERT(224,  224,    224)
#define GRAY1               RGB565CONVERT(192,  192,    192)   
#define GRAY2               RGB565CONVERT(160,  160,    160)   
#define GRAY3               RGB565CONVERT(128,  128,    128)
#define GRAY4               RGB565CONVERT(96,   96,     96)
#define GRAY5               RGB565CONVERT(64,   64,     64)
#define GRAY6               RGB565CONVERT(32,   32,     32)
  
/*
// Section : SSD1963 Command --------------------------------------------------
// - HX83XX Register Names ----------------------------------------------------
#define COL_ADD_START_HI  0x02  // W/R -   SC[15:8] (8'b0000_0000)
#define COL_ADD_START_LO  0x03  // W/R -   SC[7:0] (8'b0000_0000)

#define COL_ADD_END_HI    0x04  // W/R -   EC[15:8] (8'b0000_0000)
#define COL_ADD_END_LO    0x05  // W/R -   EC[7:0] (8'b1110_1111)

#define ROW_ADD_START_HI  0x06  // W/R -   SP[15:8] (8'b0000_0000)
#define ROW_ADD_START_LO  0x07  // W/R -   SP[7:0] (8'b0000_00000)

#define ROW_ADD_END_HI    0x08  // W/R -   EP[15:8] (8'b0000_0001)
#define ROW_ADD_END_LO    0x09  // W/R -   EP[7:0] (8'b0011_1111)

//#define MEM_ACCESS        0x16  // W/R -   MY(0) MX(0) MV(0) ML(0) BGR(0) - - -
#define MEM_ACCESS        0x36
//#define SRAM_WRITE        0x22  // W/R SRAM Write
#define SRAM_WRITE        0x2C
*/

#define Com_NOP                 0x00   // brief No opeation
#define Com_Reset               0x01   // brief Software reset
#define Com_GetPowerMode        0x0A   // brief Get power mode
#define Com_GetAddressMode      0x0B   // brief Get the frame memory t the display panel read order
#define Com_GetPixelFormat      0x0C   // brief Get the current pixel format
#define Com_GetDisplayModule    0x0D   // brief Get the current display format
#define Com_GetSignalMode       0x0E   // brief Get the display mode from peripharel
#define Com_EnterSleepMode      0x10   // brief Enter the sleep mode
#define Com_ExitSleepMode       0x11   // brief Turn on the panel
#define Com_EnterPartialMode    0x12   // brief Enter partial mode
#define Com_EnterNormalMode     0x13   // brief Enter normal mode
#define Com_ExitInvertMode      0x20   // brief Exit the invert mode
#define Com_EnterInvertMode     0x21

#define Com_SetGammaCurve       0x26

#define Com_SetDisplayOff       0x28
#define Com_SetDisplayOn        0x29

#define Com_SetColumnAddress    0x2A

#define Com_SetPageAddress      0x2B

#define Com_WriteMemory         0x2C

#define Com_ReadMomery          0x2E

#define Com_SetPartialArea      0x30

#define Com_SetScrollArea       0x33

#define Com_SetTearOff          0x34
#define Com_SetTearOn           0x35

#define Com_SetAddressMode      0x36

#define Com_SetScrollStart      0x37

#define Com_ExtiIdleMode        0x38
#define Com_EnterIdleMode       0x39

#define Com_SetPixelFormat      0x3A

#define Com_WriteMemoryContinue 0x3C

#define Com_ReadMemoryContinue  0x3E

#define Com_SetTearScanLine     0x44
#define Com_GetTearScanLine     0x45

#define Com_GetDDB              0xA1

#define Com_SetLCDMode          0xB0
#define Com_GetLCDMode          0xB1

#define Com_SetHoriPeriod       0xB4
#define Com_GetHoriPeriod       0xB5

#define Com_SetVertPeriod       0xB6
#define Com_GetVertPeriod       0xB7

#define Com_SetGPIOConf         0xB8
#define Com_GetGPIOConf         0xB9

#define Com_SetGPIOValue        0xBA

#define Com_GetGPIOStatus       0xBB

#define Com_SetPostProcessor    0xBC
#define Com_GetPostProcessor    0xBD

#define Com_SetPWMConf          0xBE
#define Com_GetPWMConf          0xBF

#define Com_SetLCDGenerator0    0xC0
#define Com_GetLCDGenerator0    0xC1

#define Com_SetLCDGenerator1    0xC2
#define Com_GetLCDGenerator1    0xC3

#define Com_SetLCDGenerator2    0xC4
#define Com_GetLCDGenerator2    0xC5

#define Com_SetLCDGenerator3    0xC6
#define Com_GetLCDGenerator3    0xC7

#define Com_SetDynamicBackLightConf      0xD0
#define Com_GetDynamicBackLightConf      0xD1

#define Com_SetDynamicBackLightThreshold 0xD4
#define Com_GetDynamicBackLightThreshold 0xD5

#define Com_SetPLLStart         0xE0

#define Com_SetPLLConfig        0xE2
#define Com_GetPLLConfig        0xE3

#define Com_GetPLLStatus        0xE4

#define Com_SetDeepSleepMode    0xE5

#define Com_GetPixelClock       0xE7
#define Com_SetPixelClock       0xE6

#define Com_SetPixelInterface   0xF0
#define Com_GetPixelInterface   0xF1

// End : SSD1963 Command ------------------------------------------------------

#define swap(a, b) { int16_t t = a; a = b; b = t; }
#define LOW 0
#define HIGH 1

class SSD1963 : public LCD {
  public:
    SSD1963(PinName CS, PinName RESET, PinName RS, PinName WR, BusInOut* DATA_PORT, PinName RD, PinName BL = NC, backlight_t blType = Constant);
    void begin(void);
    void reset(void);
                
    uint16_t Color565(uint8_t r, uint8_t g, uint8_t b);

  protected:
     /** Assigns a chunk of the display memory to receive data.
     *
     * When data is sent to the display after this function completes, the opertion will
     * start from the begining of the assigned address (pixel position) and the pointer
     * will be automatically incremented so that the next data write operation will continue
     * with the next pixel from the memory block.  If more data is written than available
     * pixels, at the end of the block the pointer will jump back to its beginning and
     * commence again, until the next address change command is sent to the display.
     *
     * \param x1 The X coordinate of the pixel at the beginning of the block.
     * \param y1 The Y coordinate of the pixel at the beginning of the block.
     * \param x2 The X coordinate of the pixel at the end of the block.
     * \param y2 The Y coordinate of the pixel at the end of the block.
     * \remarks Addressing commands are controller-specific and this function needs to be
     *          implemented separately for each available controller.
     */
    virtual void SetXY( unsigned short x1, unsigned short y1, unsigned short x2, unsigned short y2 );

    /** Sets the color of the pixel at the address pointer of the controller.
     *
     * This function is to be provided by each implementation separately in
     * order to account for different color depth used by the controller.
     * \param color The color of the pixel.
     * \param mode The depth (palette) of the color.
     */
    virtual void SetPixelColor( unsigned int color, colordepth_t mode = RGB24 );
    
    virtual void WriteData(unsigned short data);
    virtual void WriteCmd(unsigned short cmd);
    uint16_t readData(void);
    void writeRegister(uint16_t addr, uint16_t data);
        
  private:
    DigitalOut  _lcd_pin_wr;
    BusInOut*   _lcd_port;
    DigitalOut  _lcd_pin_rd;
};

#endif
