#include "mbed.h"
#include "I2CDriver.h"
#include "SPIDriver.h"
#include "LedCube.h"
#include "rtos.h"

const int FRAMES = 700;
const int SPIFREQ = 1000000; //frequency of SPI interface
const char ADDRESS = 0x60; //address van I2C interface
unsigned char buffer[512];
Mutex valuesmutex;

LedCube* ledcube = new LedCube();
SPIDriver* spidriver = new SPIDriver(p5, NC, p7, p8, p11, SPIFREQ);
I2CDriver* i2cdriver = new I2CDriver(p28, p27, ADDRESS);
DigitalOut blank(p9);

void streamThread(void const* args);
void inputThread(void const* args);

int main()
{
    /* while(true){
         spidriver->sendLayer(ledcube);
         wait(0.5);
     }  */
    /*  blank = 1;
      wait_ms(1);*/
    blank = 0;

    for(int i = 0; i < 512; i++) buffer[i] = 1;

    ledcube->setData(buffer);

    /* while(1){}*/

    /* while(true) {
          char ledvalue = ledcube->getNextValue();
          printf("%d ", ledvalue);
          spidriver->write(ledvalue);
          wait(0.2);
      }*/

    //  spidriver->testPhase(FRAMES);

    /*  printf("Initiating stream from following matrices\n\r");
      ledcube->printAll();
      printf("Streaming...\n\r");*/
    /*   spidriver->sendLayer(ledcube);
       wait(0.00125);    //voor 100 Hz
       spidriver->pulseLatch();*/
     
   /* while(true) {
        spidriver->sendFrame(ledcube);
    }*/
    
    Thread thread1(streamThread);
    Thread thread2(inputThread);
    while(true){}
    
}//end main

void streamThread(void const* args)
{
    while(true) {
        valuesmutex.lock();
        spidriver->sendFrame(ledcube);
        valuesmutex.unlock();
    }
}

void inputThread(void const* args)
{
    while(true) {
        valuesmutex.lock();
        i2cdriver->pollForInput(ledcube);
        valuesmutex.unlock();
    }
}