#ifndef MBED_SPIDriver_H
#define MBED_SPIDriver_H

#include "mbed.h"
#include "LedCube.h"

class SPIDriver{
    public: 
        SPIDriver(PinName pin1, PinName pin2, PinName pin3, PinName latchpin, PinName cspin, const int freq);
        ~SPIDriver();
        void write(uint8_t ledcolor);
        void reversedwrite(uint8_t ledcolor);
        void pulseLatch();
        void sendLayer(LedCube* ledc);
        void sendFrame(LedCube* ledc);
        void sendTestFrame(LedCube* ledc);
        void sendTest(LedCube* ledc, int frames);
        void testPhase(int xframes);
        uint8_t reverse_byte(uint8_t byte);
        
    private: 
        SPI spi;
        DigitalOut *latch;
        DigitalOut *cs;
};
#endif

