#include "SPIDriver.h"
#include "mbed.h"
#include "rtos.h"

SPIDriver::SPIDriver(PinName pin1, PinName pin2, PinName pin3, PinName latchpin, PinName cspin, const int freq) : spi(pin1, pin2, pin3){
    spi.format(8, 3);
    spi.frequency(freq);
    
    latch = new DigitalOut(latchpin);
    cs = new DigitalOut(cspin);
    
    *latch = 0;
    *cs = 1;
}

SPIDriver::~SPIDriver(){
}

void SPIDriver::write(uint8_t ledcolor){
    *cs = 0;
    spi.write(ledcolor); 
    *cs = 1;
}

void SPIDriver::reversedwrite(uint8_t ledcolor){
    *cs = 0;
    spi.write(reverse_byte(ledcolor)); 
    *cs = 1;
}

void SPIDriver::pulseLatch(){
    *latch = 1;
    wait(0.000001);
    *latch = 0;    
}

void SPIDriver::sendLayer(LedCube* ledc){
        unsigned char valueled = ledc->getNextValue();
    //    printf("%d ", valueled);
        write(valueled);      //eerst laag selecteren, SPI zendt normaalgezien MSB first 
        for(int j = 0; j < 24; j++) {      
            unsigned char valueled = ledc->getNextValue();
     //       printf("%d ", valueled);
            write(valueled);  //ledwaarden zelf nog altijd apart, omdat ze mogelijk gespiegeld moeten doorgestuurd worden
        }                                  //(LSB first)                              
}

void SPIDriver::sendFrame(LedCube* ledc){
    for(int i = 0; i < 8; i++) {  
        sendLayer(ledc);                                          
        wait(0.00025);     //voor 100 Hz
        pulseLatch();
    }//end outer for loop
   // printf("Frame gezonden!!\n\r");
}

void SPIDriver::sendTestFrame(LedCube* ledc){
    for(int i = 0; i < 8; i++) {  
        sendLayer(ledc);                                          
        wait(0.00125);    
        pulseLatch();
    }
}

void SPIDriver::sendTest(LedCube* ledc, int frames){
    printf("Testing...\n\r");
    for(int i = 0; i < frames; i++) {
        sendTestFrame(ledc);
    }
}

void SPIDriver::testPhase(int xframes){
    printf("Initiating Test phase\n\r");
    
    LedCube* testledcube1 = new LedCube();
  //  testledcube1->testMode(LedCube::firsthalfwhite);
    sendTest(testledcube1, xframes);
    
    LedCube* testledcube2 = new LedCube();
  //  testledcube2->testMode(LedCube::secondhalfwhite);
    sendTest(testledcube2, xframes);
    
    printf("Test phase terminated!\n\r");    
}

uint8_t SPIDriver::reverse_byte(uint8_t byte)
{
    return (__rbit(byte) >> 24) & 0xFF; // reverse a byte in a 32-bit value, and extract the byte
}