#ifndef MBED_I2CDRIVER_H
#define MBED_I2CDRIVER_H

#include "mbed.h"
#include "LedCube.h"

class I2CDriver
{
public:
    I2CDriver(PinName pin1, PinName pin2, const char addr);
    ~I2CDriver();
    uint8_t read(void);
    uint8_t read(char* dat, int lengte);
    int receive(void);
    void pollForInput(LedCube* ledc);

    enum RxStatus {
        NoData         = 0,
        ReadAddressed  = 1,
        WriteGeneral   = 2,
        WriteAddressed = 3
    };
private:
    I2CSlave slave;
    static const int SIZE = 512;
    char databuffer[SIZE];
};
#endif
