#include "I2CDriver.h"
#include "mbed.h"

I2CDriver::I2CDriver(PinName pin1, PinName pin2, const char addr) : slave(pin1, pin2)
{
    slave.address(addr);
}

I2CDriver::~I2CDriver()
{
}

uint8_t I2CDriver::read(void)
{
    return ((uint8_t) slave.read());
}

uint8_t I2CDriver::read(char* dat, int lengte)
{
    return slave.read(dat, lengte);
}

int I2CDriver::receive(void)
{
    return slave.receive();
}

void I2CDriver::pollForInput(LedCube* ledc)
{
    if(receive() == I2CDriver::WriteAddressed) {
        slave.read(databuffer, SIZE);
        unsigned char databfr[512];
        for(int i =0; i < 512; i++) databfr[i] = databuffer[i];
        ledc->setData(databfr);
    }
    //printf("Gepollt!!\n\r");
}

