#include "LedCube.h"

LedCube::LedCube(){
    //construct needed arrays to store the output values
    status = address;
    x_current=0;
    y_current=0;
    z_current=0;
    
    layer_current=0; 
    layer_oneHot= 1;
    rank_current = 0;
}
//return the next byte of data to send
unsigned char LedCube::getNextValue(){
    unsigned char output;
    switch(status){
        case address  :
           status=red;
           output = layer_oneHot;
           break;
        case red  :
           output = rValues[layer_current][rank_current];//return red value
           if(rank_current!=7)rank_current++;
           else {
                status = green; // next time give red color 
                rank_current =0; //put the rank back on zero
           }
           break;      
        case green  :
           output = gValues[layer_current][rank_current];//return green value
           if(rank_current!=7)rank_current++;
           else {
                status = blue; // next time give green color 
                rank_current =0; //put the rank back on zero
           }
           break;      
        case blue  :
           output = bValues[layer_current][rank_current];//return blue value
           if (rank_current != 7){ 
               rank_current++;  //increase the rank            
           }
           else {
                layer_oneHot = layer_oneHot << 1;
                if(layer_oneHot == 0) layer_oneHot = 1; //get the new address
                status = address; // next time give blue color 
                rank_current =0; //put the rank back on zero for the next layer
                if(layer_current!=7) layer_current++; else layer_current = 0; //if its not the last layer increase it
           }
           break;      
    }
    return output;
}
//setData set the arrays to the new frame
void LedCube::setData(unsigned char* data){
    //convert raw data too rgb values 
    for(int i = 0; i < 8; i++) { 
            int z = i * 64; // a layer is 64 byte 
            for(int j = 0; j < 8; j++) {
                        int y = j * 8; //a collum is 8 rows
                        unsigned char weight = 128;
                        for(int k = 0; k < 8; k++) {  //iterate for each row
                            unsigned char digitbuffer = data[z+y+k]; //read byte consisting of color 1 led 
                            //now select the right color
                            if(k == 0) {                             
                                                rValues[i][j] = 0;
                                                gValues[i][j] = 0;
                                                bValues[i][j] = 0;
                            }
                            if(digitbuffer >= 4) {
                                                rValues[i][j] += weight;
                                                digitbuffer = digitbuffer - 4;
                            }
                            if(digitbuffer >= 2) {
                                                gValues[i][j] += weight;
                                                digitbuffer = digitbuffer - 2;
                            }
                            if(digitbuffer >= 1) {
                                                bValues[i][j] += weight;
                            }
                            weight = weight >> 1;
                        }
             }
     }
}
void LedCube::printValues(Color_led color){
    unsigned char(*toprint)[8][8];
    switch (color)
    {
    case l_red:
        toprint = &rValues;
        break;
    case l_green:
        toprint = &gValues;
        break;
    case l_blue:
        toprint = &bValues;
        break;
    default:
        toprint = &rValues; //set the default to red should not happen anyway
        break;
    }
    for (int i = 0; i < 8; i++){
        for (int j = 0; j < 8; j++){
            printf("%03d ", (*toprint)[i][j]);
        }
        printf("\n\r");
    }
}
void LedCube::printAll(){
    printf("Red Matrix: \n\r");
    printValues(l_red);
    printf("\n\rGreen Matrix: \n\r");
    printValues(l_green);
    printf("\n\rBlue Matrix: \n\r");
    printValues(l_blue);
}