#include "mbed.h"
  #include "HIDScope.h"        // Require the HIDScope library
 
  HIDScope    scope(2);        // Instantize a 2-channel HIDScope object
  Ticker      scopeTimer;      // Instantize the timer for sending data to the PC 
  
  AnalogIn    a0(A0);          // Using an analog input to obtain data 
  
  int main()
  {
    
    // Attach the HIDScope::send function to the timer at a 10.000 us interval (100 Hz)
    scopeTimer.attach_us(&scope, &HIDScope::send, 1e4);
    
    // Read from the analog input in an endless loop. Two channels are written each iteration. 
    // Note that the control loop can run at a different frequency (1 kHz in this case)
    while(1){
        scope.set(0, a0.read());
        scope.set(1, a0.read());
        wait_us(1000);
    };    
    
  }   

