#include "mbed.h"
//#include "HIDScope.h"
//#include "QEI.h"
#include "MODSERIAL.h"
//#include "BiQuad.h"
//#include "FastPWM.h"


//Filters EMG
//Filters Linker Biceps
//In de volgorde High pass, notch, low pass
BiQuad LBHP( 0.966007451305314, -1.932014902610628, 0.966007451305314, -1.931328283956411, 0.932701521264844);
BiQuadChain LBHP;
BiQuad LBN( 0.648071822280979, -1.048602235601706, 0.648071822280979, -1.048602235601706, 0.296143644561958);
BiQuadChain LBN;
BiQuad LBLP( 3.902484217617605e-05, 7.804968435235210e-05, 3.902484217617605e-05, -1.976891517770743, 0.977047617139448);
BiQuadChain LBLP;


//Filters Rechter Biceps
//In de volgorde High pass, notch, low pass
BiQuad RBHP( 0.966007451305314, -1.932014902610628, 0.966007451305314, -1.931328283956411, 0.932701521264844);
BiQuadChain RBHP;
BiQuad RBN( 0.648071822280979, -1.048602235601706, 0.648071822280979, -1.048602235601706, 0.296143644561958); 
BiQuadChain RBN;
BiQuad RBLP( 3.902484217617605e-05, 7.804968435235210e-05, 3.902484217617605e-05, -1.976891517770743, 0.977047617139448);
BiQuadChain RBLP;

//Filters Rechter Triceps
//In de volgorde High pass, notch, low pass
BiQuad RTHP( 0.966007451305314, -1.932014902610628, 0.966007451305314, -1.931328283956411, 0.932701521264844);
BiQuadChain RTHP;
BiQuad RTN( 0.648071822280979, -1.048602235601706, 0.648071822280979, -1.048602235601706, 0.296143644561958); 
BiQuadChain RTN;
BiQuad RTLP( 3.902484217617605e-05, 7.804968435235210e-05, 3.902484217617605e-05, -1.976891517770743, 0.977047617139448);
BiQuadChain RTLP;

double emgLBHP;
double emgLBNotch;
double emgAbsLPHP;
double emgLBLP;
 
double emgRBHP;
double emgRBNotch;
double emgAbsRBHP;
double emgLPRB;
 
double emgRTNotch;
double emgRTHP;
double emgAbsRTHP;
double emgRTLP;
 
AnalogIn emgLB(A0);     //read EMG
AnalogIn emgRB(A1);     //read EMG
AnalogIn emgRT(A2);     //read EMG

void Filteren() 
{
    emgLBHP = LBHP.step(emgLB.read() );     // High-pass filter
    emgLBNotch = LBN.step(emgLBHP);         // Notch filter
    emgAbsLBNotch = abs(emgLBNotch);        // Absolute value
    emgLBLP = LBLP.step(emgAbsLBNotch);     // Low-pass filter
    //??emgMEANSUBLB = emgLPLB - RESTMEANLB;    //substract the restmean value
    //??LBF = emgLPLB/MVCLB;       // Scale to maximum signal: useful for motor. LBF should now be between 0-1.
    
    emgRBHP = RBHP.step(emgRB.read()); 
    emgRBNotch = RBN.step(emgRBHP);     
    emgAbsRBNotch = abs(emgRBNotch);            
    emgRBLP = RBLP.step(emgAbsRBNotch);       
    //??emgMEANSUBLB = emgLPLB - RESTMEANLB;
    //??RBF = emgLPRB/MVCRB;       // Scale to maximum signal: useful for motor
    
    emgRTHP = RTHP.step(emgRT.read());     
    emgRTNotch = RTN.step(emgRTHP);  
    emgAbsRTNotch = abs(emgRTNotch);            
    emgRTLP = RTLP.step(emgAbsRTNotch);       
   // emgMEANSUBRT = emgLPRT - RESTMEANRT;    //substract the restmean value
   //RTF = emgLPRT/MVCRT;       // Scale to maximum signal: useful for motor
