#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

AnalogIn EMG(A0);
HIDScope scope(2);

BiQuadChain bqc;
BiQuad bq1( 9.35527e-01, -1.87105e+00, 9.35527e-01, -1.86689e+00, 8.75215e-01 );
BiQuad bq2( 9.90278e-01, -1.40046e+00, 9.90278e-01, -1.40046e+00, 9.80555e-01 );
BiQuad bq3( 2.20594e-05, 4.41189e-05, 2.20594e-05, -1.98667e+00, 9.86760e-01 );

Ticker meetisweet;
bool sdar = false;
void spork(){
    sdar = true;
    }
    
double weten;  
void meten(){
    weten = bqc.step(EMG.read());
    weten = fabs(weten);
    weten = bq3.step(weten)*5;
    scope.set(0,EMG.read());
    if (weten < 0.2){
        scope.set(1,0);
    } else if (weten >= 0.2 && weten < 0.5){
        scope.set(1,0.33);
    } else if (weten >= 0.5 && weten < 0.8){
        scope.set(1,0.67);
    } else {
        scope.set(1,1);
    }
    scope.send();
    }
int main()
{
    bqc.add( &bq1 ).add( &bq2 );
    meetisweet.attach(spork,1.0/400);

    while(true){
     
        if (sdar == true){
            meten();
            sdar = false;
        }
    }
}