#include "mbed.h"
#include "HIDScope.h"
#include "MODSERIAL.h"
#include "BiQuad.h"


// Two analog inputs to read from
AnalogIn    a0(A0);
AnalogIn    a1(A1);
AnalogIn    a2(A2);
AnalogIn    a3(A3);
DigitalOut ledr(LED_RED);
MODSERIAL pc(USBTX, USBRX);


// Define the HIDScope and Ticker objects
HIDScope    scope(2);
Ticker      scopeTimer;
Ticker      EMGTicker;

// BiQuad filters
    //BiQuad Chains
BiQuadChain bqc1;
BiQuadChain bqc2;
BiQuadChain bqc3;
BiQuadChain bqc4;

    //High pass filters 20 Hz
BiQuad HP_emg1(1,-2,1,-1.142980502539901,0.412801598096189);
BiQuad HP_emg2(1,-2,1,-1.142980502539901,0.412801598096189); 
BiQuad HP_emg3(1,-2,1,-1.142980502539901,0.412801598096189); 
BiQuad HP_emg4(1,-2,1,-1.142980502539901,0.412801598096189);

    //Notch filters 50 Hz
BiQuad Notch_emg1(1,-1.225251386743515e-16,1,-1.187919512117619e-16,0.939062505817492); 
BiQuad Notch_emg2(1,-1.225251386743515e-16,1,-1.187919512117619e-16,0.939062505817492); 
BiQuad Notch_emg3(1,-1.225251386743515e-16,1,-1.187919512117619e-16,0.939062505817492); 
BiQuad Notch_emg4(1,-1.225251386743515e-16,1,-1.187919512117619e-16,0.939062505817492);


// Global variables
float EMGdata1;
float EMGdata2;
float EMGdata3;
float EMGdata4;
int    count;

void ReadEMG()
{
    EMGdata1 = a0.read(); // store values in the scope
    EMGdata2 = a1.read();
    EMGdata3 = a2.read();
    EMGdata4 = a3.read();
}

// EMG High pass filters
float EMG_HP1(float EMGdata) //data 1
{
    float HP_abs_EMGdata = bqc1.step(EMGdata);

    return fabs(HP_abs_EMGdata);
}

float EMG_HP2(float EMGdata) //data 2
{
    float HP_abs_EMGdata = bqc2.step(EMGdata);

    return fabs(HP_abs_EMGdata);
}

float EMG_HP3(float EMGdata) //data 3
{
    float HP_abs_EMGdata = bqc3.step(EMGdata);

    return fabs(HP_abs_EMGdata);
}

float EMG_HP4(float EMGdata) // data 4
{
    float HP_abs_EMGdata = bqc4.step(EMGdata);

    return fabs(HP_abs_EMGdata);
}

// EMG moving filter
float EMG_mean (float EMGarray[100])
{
    float sum = 0.0;

    for(int j=0; j<100; j++) 
        {
            sum += EMGarray[j];
        }

    float EMG_filt = sum / 100.0;
    
    return EMG_filt;
}

// Filtered signal to output between -1 and 1
float filt2kin (float EMG_filt1, float EMG_filt2, float max1, float max2)
{
    float EMG_scaled1 = EMG_filt1 / max1;
    float EMG_scaled2 = EMG_filt2 / max2;

    float kin_input = EMG_scaled2 - EMG_scaled1;

    if (kin_input > 1.0) {
        kin_input = 1.0;
    }
    if (kin_input < -1.0) {
        kin_input = -1.0;
    }

    return kin_input;
}

void EMG_filtering ()
{     
    ReadEMG();

    float HP_abs_EMGdata1 =  EMG_HP1(EMGdata1);
    float HP_abs_EMGdata2 =  EMG_HP2(EMGdata2);
    float HP_abs_EMGdata3 =  EMG_HP3(EMGdata3);
    float HP_abs_EMGdata4 =  EMG_HP4(EMGdata4);
    
    static float EMG_array1[100];
    static float EMG_array2[100];
    static float EMG_array3[100];
    static float EMG_array4[100];
    
    // Fill array 1
     for(int i = 100-1; i >= 1; i--) 
        {
            EMG_array1[i] = EMG_array1[i-1];
        }
    EMG_array1[0] = HP_abs_EMGdata1;
    
    // Fill array 2
     for(int i = 100-1; i >= 1; i--) 
        {
            EMG_array2[i] = EMG_array2[i-1];
        }
    EMG_array2[0] = HP_abs_EMGdata2;
    
    // Fill array 3
     for(int i = 100-1; i >= 1; i--) 
        {
            EMG_array3[i] = EMG_array3[i-1];
        }
    EMG_array3[0] = HP_abs_EMGdata3;
    
    // Fill array 4
     for(int i = 100-1; i >= 1; i--) 
        {
            EMG_array4[i] = EMG_array4[i-1];
        }
    EMG_array4[0] = HP_abs_EMGdata4;

    
    float EMG_filt1 = EMG_mean(EMG_array1);
    float EMG_filt2 = EMG_mean(EMG_array2);
    float EMG_filt3 = EMG_mean(EMG_array3);
    float EMG_filt4 = EMG_mean(EMG_array4);

    float max1 = 0.01;
    float max2 = 0.03;
    float max3 = 0.02;
    float max4 = 0.01;

    float kin_input_horizontal = filt2kin (EMG_filt1, EMG_filt2, max1, max2);
    float kin_input_vertical   = filt2kin (EMG_filt3, EMG_filt4, max3, max4);

    scope.set(0, kin_input_horizontal);
    scope.set(1, kin_input_vertical);
    //scope.set(2, EMG_filt3);
    //scope.set(3, EMG_filt4);
    

    count++;

    if (count == 100) 
    {
        pc.printf("EMG filt 1 = %lf \t EMG filt 2 = %lf \t EMG filt 3 = %lf \t EMG filt 4 = %lf \n\r", EMG_filt1, EMG_filt2, EMG_filt3, EMG_filt4);
        count = 0;
    }
}

int main()
{
    pc.baud(115200);
    //BiQuad chains
    bqc1.add( &HP_emg1 ).add( &Notch_emg1 );
    bqc2.add( &HP_emg2 ).add( &Notch_emg2 );
    bqc3.add( &HP_emg3 ).add( &Notch_emg3 );
    bqc4.add( &HP_emg4 ).add( &Notch_emg4 );
    
    // Attach the HIDScope::send method from the scope object to the timer at 50Hz
    scopeTimer.attach_us(&scope, &HIDScope::send, 5e3);
    EMGTicker.attach_us(EMG_filtering, 5e3);

    while(1) {}

}