#include "mbed.h"
#include "FastPWM.h"
#include "MODSERIAL.h"
#include "QEI.h"

DigitalOut gpo(D0);
DigitalOut led(LED_RED);
AnalogIn pot1(A0);
AnalogIn pot2(A1);
QEI encoder1(D10, D11, NC, 32);
QEI encoder2(D12, D13, NC, 32);
FastPWM motor1_pwm(D6);
DigitalOut motor1_richting(D7);

MODSERIAL pc(USBTX, USBRX);

int count = 0;

Ticker MotorTicker;

void read_pots(volatile double &pot1_value, volatile double &pot2_value) // read pot 1 en pot 2
{
    pot1_value = pot1.read();
    pot2_value = pot2.read();
}

double det_ref(double ref_value) //zet referentiewaarde om in positie
{
    return ref_value * 2 * 3.1416;
}

double meas_pos () //Encoder functie
{
    return encoder1.getPulses()/32.0/131.25*2.0*3.1416;
}

double comp_error (double meas_pos, double ref_pos)
{
    return ref_pos - meas_pos;
}

double comp_integral_error (double error) // compute the integral error
{
    double T = 1.0 / 400.0;
    volatile double error_integral = error_integral + error * T;
    
    return error_integral;
}

double PID_controller (double pot2_val, double error, double integral_error)
{
    
    // Proportional control
    double u_k = 5.0 * error; //20.0 * pot2_val * error;
    
    
    // Integral control
    double u_i = 20.0 * pot2_val * integral_error;
    
    
    //u definieren
    double u = u_k + u_i;
    
    // Signaal binnen de perken houden.
    if (u > 1.0)
        {
            u = 1.0;
        }
            
    else if (u < -1.0)
        {
            u = -1.0;
        }
    
    
    
    
    return u;
}

void move_mot(double u)
{
    
        if (u <= 0) 
        {
            motor1_richting = 0;
            motor1_pwm.write(-u); //write Duty cycle 
        }
        
        if (u >= 0) 
        {
            motor1_richting = 1;
            motor1_pwm.write(u); //write Duty cycle 
        }
}


void Motor_control()
{      
    volatile double pot_value;
    
    volatile double pot2_val;
    
    read_pots(pot_value, pot2_val);
    
    volatile double yref = det_ref(pot_value); // reference position
    
    volatile double y = meas_pos(); // measured position
    
    volatile double error = comp_error (y, yref);
    
    volatile double integral_error = comp_integral_error(error);
    
    volatile double u = PID_controller(pot2_val, error, integral_error); // output PID controller
    
    move_mot(u); //functie die motor laat bewegen.
       
    count++;
    //pc.printf("count = %i", count);
    
    if (count == 400) // print 1x per seconde waardes.
    {
        pc.printf("u = %lf, measured position y = %lf, reference position yref = %lf, gain = %lf, error = %lf, integral error = %lf \n\r", u, y, yref, pot2_val*20.0, error, integral_error);
        count = 0;   
    }
}


int main()
{
    pc.baud(115200);
    
    int frequency_pwm = 16700; //16.7 kHz PWM
    motor1_pwm.period(1.0/frequency_pwm); // T = 1/f
    MotorTicker.attach(Motor_control, 0.0025);
    
    while (true) 
    {}
}