#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"
#include "MODSERIAL.h"
#include <cmath>

MODSERIAL   pc(USBTX, USBRX);
Ticker      emgSampleTicker;
AnalogIn    emg0(A0);
AnalogIn    emg1(A1);
DigitalOut  ledje(LED_GREEN);
HIDScope    scope(2);        

double hf_b0 = 0.9355;
double hf_b1 = -1.8711;
double hf_b2 = 0.9355;
double hf_a1 = -1.8669;
double hf_a2 = 0.8752;

double lf_b0 = 8.7656e-5;
double lf_b1 = 1.17531e-4;
double lf_b2 = 8.7656e-5;
double lf_a1 = -1.9733;
double lf_a2 = 0.9737;

double v1 = 0, v2 = 0, u = 0;

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    // Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope'
    scope.set(0, emg0.read() );
        /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    // To indicate that the function is working, the LED is toggled
    ledje = ledje;
}


int main(){
   
  /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    emgSampleTicker.attach(&sample, 0.002);
    // empty loop, sample() is executed periodically
    while(1) {

        double emgFilter();
    {

//High Pass Filter (biquad)
    double hf_v = u - hf_a1*v1 - hf_a2*v2;
    double hf_y = hf_b0*hf_v + hf_b1*v1 + hf_b2*v2;
    v2 = v1;
    v1 = hf_v;

//Rectification
    double rect_y = fabs(hf_y);
    
//Low Pass Filter (biquad)
    double lf_v = rect_y - lf_a1*v1 - lf_a2*v2;
    double lf_y = lf_b0*hf_v + lf_b1*v1 + lf_b2*v2;
    v2 = v1;
    v1 = lf_v;
    
while(1){
    
   scope.set(1, lf_y);
   scope.send();
    
    }
    
    }

}
}
