#include "mbed.h"
//#include "HIDScope.h"
#include "BiQuad.h"

//Define objects
AnalogIn    emg0(A0); // Right arm (RA)
AnalogIn    emg1(A1); // Left arm (LA)
AnalogIn    emg2(A2); // Right leg (RL)
AnalogIn    emg3(A3); // Left leg (LL)

DigitalOut  out0(D7);
DigitalOut  out1(D6);
DigitalOut  out2(D5);
DigitalOut  out3(D4);
DigitalOut  out4(D3);
DigitalOut  out5(D2);

DigitalOut  ledmot(D0);

Ticker      sample_timer;
//HIDScope    scope( 4 ); // Scope to readout outputs; not required for robot control

DigitalOut  led1(LED_RED);
DigitalOut  led2(LED_GREEN);
DigitalOut  led3(LED_BLUE);

//------------------------------------------------------------------------------

// Biquads right arm
BiQuad bq1ra( 9.87589e-01, -1.59795e+00, 9.87589e-01, -1.59795e+00, 9.75178e-01 ); // Notch

BiQuad bq2ra( 8.48475e-01, -1.69695e+00, 8.48475e-01, -1.77831e+00, 7.92447e-01 ); // High pass
BiQuad bq3ra( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.89342e+00, 9.08464e-01 );
BiQuadChain bqc1ra;

BiQuad bq4ra( 8.06360e-04, 1.61272e-03, 8.06360e-04, -1.38762e+00, 4.92423e-01 ); // Low pass
BiQuad bq5ra( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.62994e+00, 7.53040e-01 );
BiQuadChain bqc2ra;

// Biquads left arm
BiQuad bq1la( 9.87589e-01, -1.59795e+00, 9.87589e-01, -1.59795e+00, 9.75178e-01 ); // Notch

BiQuad bq2la( 8.48475e-01, -1.69695e+00, 8.48475e-01, -1.77831e+00, 7.92447e-01 ); // High pass
BiQuad bq3la( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.89342e+00, 9.08464e-01 );
BiQuadChain bqc1la;

BiQuad bq4la( 8.06360e-04, 1.61272e-03, 8.06360e-04, -1.38762e+00, 4.92423e-01 ); // Low pass
BiQuad bq5la( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.62994e+00, 7.53040e-01 );
BiQuadChain bqc2la;

// Biquads right leg
BiQuad bq1rl( 9.87589e-01, -1.59795e+00, 9.87589e-01, -1.59795e+00, 9.75178e-01 ); // Notch

BiQuad bq2rl( 8.48475e-01, -1.69695e+00, 8.48475e-01, -1.77831e+00, 7.92447e-01 ); // High pass
BiQuad bq3rl( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.89342e+00, 9.08464e-01 );
BiQuadChain bqc1rl;

BiQuad bq4rl( 8.06360e-04, 1.61272e-03, 8.06360e-04, -1.38762e+00, 4.92423e-01 ); // Low pass
BiQuad bq5rl( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.62994e+00, 7.53040e-01 );
BiQuadChain bqc2rl;

// Biquads left leg
BiQuad bq1ll( 9.87589e-01, -1.59795e+00, 9.87589e-01, -1.59795e+00, 9.75178e-01 ); // Notch

BiQuad bq2ll( 8.48475e-01, -1.69695e+00, 8.48475e-01, -1.77831e+00, 7.92447e-01 ); // High pass
BiQuad bq3ll( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.89342e+00, 9.08464e-01 );
BiQuadChain bqc1ll;

BiQuad bq4ll( 8.06360e-04, 1.61272e-03, 8.06360e-04, -1.38762e+00, 4.92423e-01 ); // Low pass
BiQuad bq5ll( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.62994e+00, 7.53040e-01 );
BiQuadChain bqc2ll;


//------------------------------------------------------------------------------

// Moving average array
const int averagelength = 150;
double moveaverageRA[averagelength];
double moveaverageLA[averagelength];
double moveaverageRL[averagelength];
double moveaverageLL[averagelength];

double datasmoothRA;
double datasmoothLA;
double datasmoothRL;
double datasmoothLL;

// Calibration to scale all input to one
double calibrationvalueRA;
double calibrationvalueLA;
double calibrationvalueRL;
double calibrationvalueLL;

// Output variable; defined here to be used as input for the PID controller
double outputRA; 
double outputLA;
double outputRL; 
double outputLL; 

//------------------------------------------------------------------------------

// Output function ternairy output
double outputvalue(double filteredsignal,double calibrationvalue)
    {
        double output;
        if (filteredsignal < 0.25*calibrationvalue) // Muscles at rest
            {
                output = 0;
            }
        else if (filteredsignal > 0.5*calibrationvalue) // Muscles contracted a lot
            {
                output  = 2;
            }
        else // Muscles contracted a little
            {
                output = 1;
            }
        return output;        
    }

// Output function binairy output
double outputvaluebi(double filteredsignal,double calibrationvalue)
    {
        double output;
        if (filteredsignal < 0.25*calibrationvalue) // Muscles at rest
            {
                output = 0;
            }
        else // Muscles contracted
            {
                output = 1;
            }
        return output;
    }
        

//------------------------------------------------------------------------------

// Sample function; samples the emg, filters it, and sends it to HIDScope
void sample()
{

    // Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope'
    double dataRA = emg0.read();
    double dataLA = emg1.read();
    double dataRL = emg2.read();
    double dataLL = emg3.read();

    // Notch and high pass filter
    double datanotchhighRA = bqc1ra.step(dataRA);
    double datanotchhighLA = bqc1la.step(dataLA);
    double datanotchhighRL = bqc1rl.step(dataRL);
    double datanotchhighLL = bqc1ll.step(dataLL);
    
    // Full wave rectifier
    double datarectRA = fabs(datanotchhighRA);
    double datarectLA = fabs(datanotchhighLA);
    double datarectRL = fabs(datanotchhighRL);
    double datarectLL = fabs(datanotchhighLL);

    // Low pass filter
    double datalowRA = bqc2ra.step(datarectRA);
    double datalowLA = bqc2la.step(datarectLA);
    double datalowRL = bqc2rl.step(datarectRL);
    double datalowLL = bqc2ll.step(datarectLL);
    
    // Smooth function
    for (int n=0;n<(averagelength-1);n++)
        {
            moveaverageRA[n] = moveaverageRA[n+1];
            moveaverageLA[n] = moveaverageLA[n+1];
            moveaverageRL[n] = moveaverageRL[n+1];
            moveaverageLL[n] = moveaverageLL[n+1];
        }
        
    moveaverageRA[(averagelength-1)] = datalowRA;
    moveaverageLA[(averagelength-1)] = datalowLA;
    moveaverageRL[(averagelength-1)] = datalowRL;
    moveaverageLL[(averagelength-1)] = datalowLL;
    
    double sumaverageRA = 0;
    double sumaverageLA = 0;
    double sumaverageRL = 0;
    double sumaverageLL = 0;

    for(int i=0;i<averagelength;i++)
        {
            sumaverageRA = sumaverageRA+moveaverageRA[i];
            sumaverageLA = sumaverageLA+moveaverageLA[i];
            sumaverageRL = sumaverageRL+moveaverageRL[i];
            sumaverageLL = sumaverageLL+moveaverageLL[i];
        }

    datasmoothRA = sumaverageRA/averagelength;
    datasmoothLA = sumaverageLA/averagelength;
    datasmoothRL = sumaverageRL/averagelength;
    datasmoothLL = sumaverageLL/averagelength;

    // Determine output value
    outputRA = outputvalue(datasmoothRA,calibrationvalueRA);
    outputLA = outputvalue(datasmoothLA,calibrationvalueLA);
    outputRL = outputvaluebi(datasmoothRL,calibrationvalueRL);
    outputLL = outputvaluebi(datasmoothLL,calibrationvalueLL);

    // Send to scope
    //scope.set(0, outputRA);
    //scope.set(1, outputLA);
    //scope.set(2, outputRL);
    //scope.set(3, outputLL);
    
    // Send to other k64f's
    if (outputRA == 0)
        {
            out0 = 0;
            out1 = 0;
            led1 = 1;
            led2 = 0; // green
            led3 = 1;
        }
    else if (outputRA == 1)
        {
            out0 = 1;
            out1 = 0;
            led1 = 0; // red
            led2 = 1;
            led3 = 1; 
        }
    else
        {
            out0 = 1;
            out1 = 1;
            led1 = 1;
            led2 = 1; 
            led3 = 0; // blue
        }
    
    if (outputLA == 0)
        {
            out2 = 0;
            out3 = 0;
        }
    else if (outputLA == 1)
        {
            out2 = 1;
            out3 = 0;
        }
    else
        {
            out2 = 1;
            out3 = 1;
        }
    
    out4 = outputRL;    // binary output
    out5 = outputLL;    // binary output

    // Send all channels to the PC at once
    //scope.send(); 

}

//------------------------------------------------------------------------------

int main()
{   

    // Inititate leds
    led1 = 1;
    led2 = 1;
    led3 = 1;
    
    ledmot = 0;

    // Biquad chains
    // Right arm
    bqc1ra.add(&bq1ra).add(&bq2ra).add(&bq3ra);
    bqc2ra.add(&bq4ra).add(&bq5ra);
    
    // Left arm
    bqc1la.add(&bq1la).add(&bq2la).add(&bq3la);
    bqc2la.add(&bq4la).add(&bq5la);   

    // Right leg
    bqc1rl.add(&bq1rl).add(&bq2rl).add(&bq3rl);
    bqc2rl.add(&bq4rl).add(&bq5rl);
    
    // Left leg
    bqc1ll.add(&bq1ll).add(&bq2ll).add(&bq3ll);
    bqc2ll.add(&bq4ll).add(&bq5ll); 

    // Initiate calibrationvalue (arbitrary value)
    calibrationvalueRA = 1;
    calibrationvalueLA = 1;
    calibrationvalueRL = 1;
    calibrationvalueLL = 1;
    
//------------------------------------------------------------------------------

    // Attach the 'sample' function to the timer 'sample_timer'
    sample_timer.attach(&sample, 0.002);

//------------------------------------------------------------------------------
    
    // Calibration

    ledmot = 1;
    wait(3.0);
    calibrationvalueRA = datasmoothRA;
    wait(1.0);
    ledmot = 0;
    wait(1.0);    
    ledmot = 1;
    wait(3.0);
    calibrationvalueLA = datasmoothLA;
    wait(1.0);
    ledmot = 0;
    wait(1.0);
    ledmot = 1;
    wait(3.0);
    calibrationvalueRL = datasmoothRL;
    wait(1.0);
    ledmot = 0;
    wait(1.0);
    ledmot = 1;
    wait(3.0);
    calibrationvalueLL = datasmoothLL;
    wait(1.0);
    ledmot = 0;
}